/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller.chunk;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.api.chunk.CheckpointAlgorithm;
import javax.batch.api.chunk.listener.ChunkListener;
import javax.batch.api.chunk.listener.ItemProcessListener;
import javax.batch.api.chunk.listener.ItemReadListener;
import javax.batch.api.chunk.listener.ItemWriteListener;
import javax.batch.api.chunk.listener.RetryProcessListener;
import javax.batch.api.chunk.listener.RetryReadListener;
import javax.batch.api.chunk.listener.RetryWriteListener;
import javax.batch.api.chunk.listener.SkipProcessListener;
import javax.batch.api.chunk.listener.SkipReadListener;
import javax.batch.api.chunk.listener.SkipWriteListener;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.Metric;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.exception.BatchContainerServiceException;
import org.apache.batchee.container.impl.StepContextImpl;
import org.apache.batchee.container.impl.controller.SingleThreadedStepController;
import org.apache.batchee.container.impl.controller.chunk.CheckpointData;
import org.apache.batchee.container.impl.controller.chunk.CheckpointDataKey;
import org.apache.batchee.container.impl.controller.chunk.CheckpointManager;
import org.apache.batchee.container.impl.controller.chunk.CheckpointType;
import org.apache.batchee.container.impl.controller.chunk.ChunkHelper;
import org.apache.batchee.container.impl.controller.chunk.ExceptionConfig;
import org.apache.batchee.container.impl.controller.chunk.ItemCheckpointAlgorithm;
import org.apache.batchee.container.impl.controller.chunk.PersistentDataWrapper;
import org.apache.batchee.container.impl.controller.chunk.RetryHandler;
import org.apache.batchee.container.impl.controller.chunk.SkipHandler;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.proxy.InjectionReferences;
import org.apache.batchee.container.proxy.ProxyFactory;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.container.util.PartitionDataWrapper;
import org.apache.batchee.jaxb.Chunk;
import org.apache.batchee.jaxb.ItemProcessor;
import org.apache.batchee.jaxb.ItemReader;
import org.apache.batchee.jaxb.ItemWriter;
import org.apache.batchee.jaxb.Property;
import org.apache.batchee.jaxb.Step;
import org.apache.batchee.spi.BatchArtifactFactory;
import org.apache.batchee.spi.DataRepresentationService;
import org.apache.batchee.spi.PersistenceManagerService;

public class ChunkStepController
extends SingleThreadedStepController {
    private static final Logger logger = Logger.getLogger(ChunkStepController.class.getName());
    protected static final int DEFAULT_TRAN_TIMEOUT_SECONDS = 180;
    private final PersistenceManagerService persistenceManagerService;
    private final BatchArtifactFactory artifactFactory;
    private final DataRepresentationService dataRepresentationService;
    private Chunk chunk = null;
    private javax.batch.api.chunk.ItemReader readerProxy = null;
    private javax.batch.api.chunk.ItemProcessor processorProxy = null;
    private javax.batch.api.chunk.ItemWriter writerProxy = null;
    private CheckpointManager checkpointManager;
    private SkipHandler skipHandler = null;
    private CheckpointDataKey readerChkptDK = null;
    private CheckpointDataKey writerChkptDK = null;
    private List<ChunkListener> chunkListeners = null;
    private List<ItemReadListener> itemReadListeners = null;
    private List<ItemProcessListener> itemProcessListeners = null;
    private List<ItemWriteListener> itemWriteListeners = null;
    private RetryHandler retryHandler;
    protected ChunkStatus currentChunkStatus;
    protected SingleItemStatus currentItemStatus;
    protected boolean customCheckpointPolicy = false;
    protected Integer checkpointAtThisItemCount = null;
    protected int stepPropertyTranTimeoutSeconds = 180;

    public ChunkStepController(RuntimeJobExecution jobExecutionImpl, Step step, StepContextImpl stepContext, long rootJobExecutionId, BlockingQueue<PartitionDataWrapper> analyzerStatusQueue, ServicesManager servicesManager) {
        super(jobExecutionImpl, step, stepContext, rootJobExecutionId, analyzerStatusQueue, servicesManager);
        this.persistenceManagerService = servicesManager.service(PersistenceManagerService.class);
        this.artifactFactory = servicesManager.service(BatchArtifactFactory.class);
        this.dataRepresentationService = servicesManager.service(DataRepresentationService.class);
    }

    private List<Object> readAndProcess() {
        ArrayList<Object> chunkToWrite = new ArrayList<Object>();
        do {
            this.currentItemStatus = new SingleItemStatus();
            this.currentChunkStatus.incrementItemsTouchedInCurrentChunk();
            Object itemRead = this.readItem();
            if (this.currentChunkStatus.wasMarkedForRollbackWithRetry()) break;
            if (!this.currentItemStatus.isSkipped() && !this.currentChunkStatus.isFinished()) {
                Object itemProcessed = this.processItem(itemRead);
                if (this.currentChunkStatus.wasMarkedForRollbackWithRetry()) break;
                if (!this.currentItemStatus.isSkipped() && !this.currentItemStatus.isFiltered()) {
                    chunkToWrite.add(itemProcessed);
                }
            }
            if (this.currentChunkStatus.isRetryingAfterRollback()) break;
            if (!this.stepContext.getBatchStatus().equals((Object)BatchStatus.STOPPING)) continue;
            this.currentChunkStatus.setFinished(true);
        } while (!this.checkpointManager.applyCheckPointPolicy() && !this.currentChunkStatus.isFinished());
        return chunkToWrite;
    }

    private Object readItem() {
        Object itemRead = null;
        try {
            for (ItemReadListener readListenerProxy : this.itemReadListeners) {
                readListenerProxy.beforeRead();
            }
            itemRead = this.readerProxy.readItem();
            for (ItemReadListener readListenerProxy : this.itemReadListeners) {
                readListenerProxy.afterRead(itemRead);
            }
            this.currentChunkStatus.setFinished(itemRead == null);
        }
        catch (Exception e) {
            this.stepContext.setException(e);
            for (ItemReadListener readListenerProxy : this.itemReadListeners) {
                try {
                    readListenerProxy.onReadError(e);
                }
                catch (Exception e1) {
                    ExceptionConfig.wrapBatchException(e1);
                }
            }
            if (!this.currentChunkStatus.isRetryingAfterRollback()) {
                if (this.retryReadException(e)) {
                    if (!this.retryHandler.isRollbackException(e)) {
                        itemRead = this.readItem();
                    } else {
                        this.currentChunkStatus.markForRollbackWithRetry(e);
                    }
                }
                if (this.skipReadException(e)) {
                    this.currentItemStatus.setSkipped(true);
                    this.stepContext.getMetric(Metric.MetricType.READ_SKIP_COUNT).incValue();
                }
                throw new BatchContainerRuntimeException(e);
            }
            if (this.skipReadException(e)) {
                this.currentItemStatus.setSkipped(true);
                this.stepContext.getMetric(Metric.MetricType.READ_SKIP_COUNT).incValue();
            }
            if (this.retryReadException(e)) {
                if (!this.retryHandler.isRollbackException(e)) {
                    itemRead = this.readItem();
                } else {
                    this.currentChunkStatus.markForRollbackWithRetry(e);
                }
            }
            throw new BatchContainerRuntimeException(e);
        }
        catch (Throwable e) {
            throw new BatchContainerRuntimeException(e);
        }
        return itemRead;
    }

    private Object processItem(Object itemRead) {
        Object processedItem = null;
        if (this.processorProxy == null) {
            return itemRead;
        }
        try {
            for (ItemProcessListener processListenerProxy : this.itemProcessListeners) {
                processListenerProxy.beforeProcess(itemRead);
            }
            processedItem = this.processorProxy.processItem(itemRead);
            if (processedItem == null) {
                this.currentItemStatus.setFiltered(true);
            }
            for (ItemProcessListener processListenerProxy : this.itemProcessListeners) {
                processListenerProxy.afterProcess(itemRead, processedItem);
            }
        }
        catch (Exception e) {
            for (ItemProcessListener processListenerProxy : this.itemProcessListeners) {
                try {
                    processListenerProxy.onProcessError(itemRead, e);
                }
                catch (Exception e1) {
                    ExceptionConfig.wrapBatchException(e1);
                }
            }
            if (!this.currentChunkStatus.isRetryingAfterRollback()) {
                if (this.retryProcessException(e, itemRead)) {
                    if (!this.retryHandler.isRollbackException(e)) {
                        processedItem = this.processItem(itemRead);
                    } else {
                        this.currentChunkStatus.markForRollbackWithRetry(e);
                    }
                }
                if (this.skipProcessException(e, itemRead)) {
                    this.currentItemStatus.setSkipped(true);
                    this.stepContext.getMetric(Metric.MetricType.PROCESS_SKIP_COUNT).incValue();
                }
                throw new BatchContainerRuntimeException(e);
            }
            if (this.skipProcessException(e, itemRead)) {
                this.currentItemStatus.setSkipped(true);
                this.stepContext.getMetric(Metric.MetricType.PROCESS_SKIP_COUNT).incValue();
            }
            if (this.retryProcessException(e, itemRead)) {
                if (!this.retryHandler.isRollbackException(e)) {
                    processedItem = this.processItem(itemRead);
                } else {
                    this.currentChunkStatus.markForRollbackWithRetry(e);
                }
            }
            throw new BatchContainerRuntimeException(e);
        }
        catch (Throwable e) {
            throw new BatchContainerRuntimeException(e);
        }
        return processedItem;
    }

    private void writeChunk(List<Object> theChunk) {
        if (!theChunk.isEmpty()) {
            try {
                for (ItemWriteListener writeListenerProxy : this.itemWriteListeners) {
                    writeListenerProxy.beforeWrite(theChunk);
                }
                this.writerProxy.writeItems(theChunk);
                for (ItemWriteListener writeListenerProxy : this.itemWriteListeners) {
                    writeListenerProxy.afterWrite(theChunk);
                }
            }
            catch (Exception e) {
                this.stepContext.setException(e);
                for (ItemWriteListener writeListenerProxy : this.itemWriteListeners) {
                    try {
                        writeListenerProxy.onWriteError(theChunk, e);
                    }
                    catch (Exception e1) {
                        ExceptionConfig.wrapBatchException(e1);
                    }
                }
                if (!this.currentChunkStatus.isRetryingAfterRollback()) {
                    if (this.retryWriteException(e, theChunk)) {
                        if (!this.retryHandler.isRollbackException(e)) {
                            this.writeChunk(theChunk);
                        } else {
                            this.currentChunkStatus.markForRollbackWithRetry(e);
                        }
                    }
                    if (this.skipWriteException(e, theChunk)) {
                        this.stepContext.getMetric(Metric.MetricType.WRITE_SKIP_COUNT).incValueBy(1L);
                    }
                    throw new BatchContainerRuntimeException(e);
                }
                if (this.skipWriteException(e, theChunk)) {
                    this.stepContext.getMetric(Metric.MetricType.WRITE_SKIP_COUNT).incValueBy(1L);
                }
                if (this.retryWriteException(e, theChunk)) {
                    if (!this.retryHandler.isRollbackException(e)) {
                        this.writeChunk(theChunk);
                    } else {
                        this.currentChunkStatus.markForRollbackWithRetry(e);
                    }
                }
                throw new BatchContainerRuntimeException(e);
            }
            catch (Throwable e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    private ChunkStatus getNextChunkStatusBasedOnPrevious() {
        if (this.currentChunkStatus == null) {
            return new ChunkStatus();
        }
        ChunkStatus nextChunkStatus = null;
        if (this.currentChunkStatus.wasMarkedForRollbackWithRetry()) {
            this.transactionManager.begin();
            this.positionReaderAtCheckpoint();
            this.positionWriterAtCheckpoint();
            this.transactionManager.commit();
            nextChunkStatus = new ChunkStatus(ChunkStatusType.RETRY_AFTER_ROLLBACK);
            int numToProcessOneByOne = this.currentChunkStatus.getItemsToProcessOneByOneAfterRollback();
            if (numToProcessOneByOne > 0) {
                nextChunkStatus.setItemsToProcessOneByOneAfterRollback(numToProcessOneByOne);
            } else {
                nextChunkStatus.setItemsToProcessOneByOneAfterRollback(this.currentChunkStatus.getItemsTouchedInCurrentChunk());
            }
        } else if (this.currentChunkStatus.isRetryingAfterRollback()) {
            int numToProcessOneByOne = this.currentChunkStatus.getItemsToProcessOneByOneAfterRollback();
            if (numToProcessOneByOne == 1) {
                nextChunkStatus = new ChunkStatus();
            } else {
                nextChunkStatus = new ChunkStatus(ChunkStatusType.RETRY_AFTER_ROLLBACK);
                nextChunkStatus.setItemsToProcessOneByOneAfterRollback(numToProcessOneByOne - 1);
            }
        } else {
            nextChunkStatus = new ChunkStatus();
        }
        return nextChunkStatus;
    }

    private void invokeChunk() {
        try {
            this.transactionManager.begin();
            this.openReaderAndWriter();
            this.transactionManager.commit();
        }
        catch (Exception e) {
            this.rollback(e);
            return;
        }
        try {
            while (true) {
                this.currentChunkStatus = this.getNextChunkStatusBasedOnPrevious();
                this.setNextChunkTransactionTimeout();
                this.checkpointManager.beginCheckpoint();
                this.transactionManager.begin();
                for (ChunkListener chunkListener : this.chunkListeners) {
                    chunkListener.beforeChunk();
                }
                List<Object> chunkToWrite = this.readAndProcess();
                if (this.currentChunkStatus.wasMarkedForRollbackWithRetry()) {
                    this.rollbackAfterRetryableException();
                    continue;
                }
                if (chunkToWrite.size() > 0) {
                    this.writeChunk(chunkToWrite);
                }
                if (this.currentChunkStatus.wasMarkedForRollbackWithRetry()) {
                    this.rollbackAfterRetryableException();
                    continue;
                }
                for (ChunkListener chunkProxy3 : this.chunkListeners) {
                    chunkProxy3.afterChunk();
                }
                Map<CheckpointDataKey, CheckpointData> map = this.checkpointManager.prepareCheckpoints();
                PersistentDataWrapper userData = this.resolveUserData();
                try {
                    this.transactionManager.commit();
                    this.storeUserData(userData);
                    this.checkpointManager.storeCheckPoints(map);
                }
                catch (Exception e) {
                    if (this.stepContext.getException() != null) {
                        this.stepContext.setException(e);
                    }
                    if (e instanceof BatchRuntimeException) {
                        throw e;
                    }
                    throw new BatchContainerServiceException("Cannot commit the transaction for the step.", e);
                }
                this.checkpointManager.endCheckpoint();
                this.invokeCollectorIfPresent();
                this.updateNormalMetrics(chunkToWrite.size());
                if (this.currentChunkStatus.isFinished()) break;
            }
            this.transactionManager.begin();
            if (this.doClose()) {
                this.transactionManager.commit();
            } else {
                this.transactionManager.rollback();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failure in Read-Process-Write Loop", e);
            for (ChunkListener chunkProxy : this.chunkListeners) {
                try {
                    chunkProxy.onError(e);
                }
                catch (Exception e1) {
                    logger.log(Level.SEVERE, e1.getMessage(), e1);
                }
            }
            this.rollback(e);
        }
        catch (Throwable t) {
            this.rollback(t);
        }
    }

    private void updateNormalMetrics(int writeCount) {
        int readCount = this.currentChunkStatus.getItemsTouchedInCurrentChunk();
        if (this.currentChunkStatus.isFinished() && !BatchStatus.STOPPING.equals((Object)this.stepContext.getBatchStatus())) {
            --readCount;
        }
        int filterCount = readCount - writeCount;
        if (readCount < 0 || filterCount < 0 || writeCount < 0) {
            throw new IllegalStateException("Somehow one of the metrics was less than zero.  Read count: " + readCount + ", Filter count: " + filterCount + ", Write count: " + writeCount);
        }
        this.stepContext.getMetric(Metric.MetricType.COMMIT_COUNT).incValue();
        this.stepContext.getMetric(Metric.MetricType.READ_COUNT).incValueBy(readCount);
        this.stepContext.getMetric(Metric.MetricType.FILTER_COUNT).incValueBy(filterCount);
        this.stepContext.getMetric(Metric.MetricType.WRITE_COUNT).incValueBy(writeCount);
    }

    private boolean doClose() {
        try {
            this.readerProxy.close();
            this.writerProxy.close();
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollback(Throwable t) {
        try {
            try {
                this.doClose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.transactionManager.setRollbackOnly();
            if (t instanceof Exception) {
                Exception e = (Exception)t;
                for (ChunkListener chunkProxy : this.chunkListeners) {
                    try {
                        chunkProxy.onError(e);
                    }
                    catch (Exception e1) {
                        logger.log(Level.SEVERE, e1.getMessage(), e1);
                    }
                }
            }
            this.stepContext.getMetric(Metric.MetricType.ROLLBACK_COUNT).incValue();
        }
        finally {
            int txStatus = this.transactionManager.getStatus();
            if (txStatus == 0 || txStatus == 1) {
                this.transactionManager.rollback();
            }
            throw new BatchContainerRuntimeException("Failure in Read-Process-Write Loop", t);
        }
    }

    private void rollbackAfterRetryableException() throws Exception {
        this.doClose();
        for (ChunkListener chunkProxy : this.chunkListeners) {
            try {
                chunkProxy.onError(this.currentChunkStatus.getRetryableException());
            }
            catch (Exception e1) {
                logger.log(Level.SEVERE, e1.getMessage(), e1);
            }
        }
        this.transactionManager.rollback();
        this.stepContext.getMetric(Metric.MetricType.ROLLBACK_COUNT).incValue();
    }

    @Override
    protected void invokeCoreStep() throws BatchContainerServiceException {
        this.chunk = this.step.getChunk();
        this.initializeChunkArtifacts();
        this.initializeCheckpointManager();
        this.invokeChunk();
    }

    private void initializeCheckpointManager() {
        Object checkpointAlgorithm = null;
        this.checkpointAtThisItemCount = ChunkHelper.getItemCount(this.chunk);
        int timeLimitSeconds = ChunkHelper.getTimeLimit(this.chunk);
        this.customCheckpointPolicy = ChunkHelper.isCustomCheckpointPolicy(this.chunk);
        if (!this.customCheckpointPolicy) {
            ItemCheckpointAlgorithm ica = new ItemCheckpointAlgorithm();
            ica.setItemCount(this.checkpointAtThisItemCount);
            ica.setTimeLimitSeconds(timeLimitSeconds);
            checkpointAlgorithm = ica;
        } else {
            if (this.chunk.getCheckpointAlgorithm() == null) {
                throw new IllegalArgumentException("Configured checkpoint-policy of 'custom' but without a corresponding <checkpoint-algorithm> element.");
            }
            List<Property> propList = this.chunk.getCheckpointAlgorithm().getProperties() == null ? null : this.chunk.getCheckpointAlgorithm().getProperties().getPropertyList();
            InjectionReferences injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, propList);
            checkpointAlgorithm = ProxyFactory.createCheckpointAlgorithmProxy(this.artifactFactory, this.chunk.getCheckpointAlgorithm().getRef(), injectionRef, this.jobExecutionImpl);
        }
        this.checkpointManager = new CheckpointManager(this.readerProxy, this.writerProxy, (CheckpointAlgorithm)checkpointAlgorithm, this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId(), this.persistenceManagerService, this.dataRepresentationService);
        this.stepPropertyTranTimeoutSeconds = this.initStepTransactionTimeout();
    }

    private void initializeChunkArtifacts() {
        ItemWriter itemWriter;
        ItemReader itemReader = this.chunk.getReader();
        List<Property> itemReaderProps = itemReader.getProperties() == null ? null : itemReader.getProperties().getPropertyList();
        InjectionReferences injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, itemReaderProps);
        this.readerProxy = ProxyFactory.createItemReaderProxy(this.artifactFactory, itemReader.getRef(), injectionRef, this.jobExecutionImpl);
        ItemProcessor itemProcessor = this.chunk.getProcessor();
        if (itemProcessor != null) {
            List<Property> itemProcessorProps = itemProcessor.getProperties() == null ? null : itemProcessor.getProperties().getPropertyList();
            injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, itemProcessorProps);
            this.processorProxy = ProxyFactory.createItemProcessorProxy(this.artifactFactory, itemProcessor.getRef(), injectionRef, this.jobExecutionImpl);
        }
        List<Property> itemWriterProps = (itemWriter = this.chunk.getWriter()).getProperties() == null ? null : itemWriter.getProperties().getPropertyList();
        injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, itemWriterProps);
        this.writerProxy = ProxyFactory.createItemWriterProxy(this.artifactFactory, itemWriter.getRef(), injectionRef, this.jobExecutionImpl);
        InjectionReferences injectionRef2 = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, null);
        this.chunkListeners = this.jobExecutionImpl.getListenerFactory().getListeners(ChunkListener.class, this.step, injectionRef2, this.jobExecutionImpl);
        this.itemReadListeners = this.jobExecutionImpl.getListenerFactory().getListeners(ItemReadListener.class, this.step, injectionRef2, this.jobExecutionImpl);
        this.itemProcessListeners = this.jobExecutionImpl.getListenerFactory().getListeners(ItemProcessListener.class, this.step, injectionRef2, this.jobExecutionImpl);
        this.itemWriteListeners = this.jobExecutionImpl.getListenerFactory().getListeners(ItemWriteListener.class, this.step, injectionRef2, this.jobExecutionImpl);
        List<SkipProcessListener> skipProcessListeners = this.jobExecutionImpl.getListenerFactory().getListeners(SkipProcessListener.class, this.step, injectionRef2, this.jobExecutionImpl);
        List<SkipReadListener> skipReadListeners = this.jobExecutionImpl.getListenerFactory().getListeners(SkipReadListener.class, this.step, injectionRef2, this.jobExecutionImpl);
        List<SkipWriteListener> skipWriteListeners = this.jobExecutionImpl.getListenerFactory().getListeners(SkipWriteListener.class, this.step, injectionRef2, this.jobExecutionImpl);
        List<RetryProcessListener> retryProcessListeners = this.jobExecutionImpl.getListenerFactory().getListeners(RetryProcessListener.class, this.step, injectionRef2, this.jobExecutionImpl);
        List<RetryReadListener> retryReadListeners = this.jobExecutionImpl.getListenerFactory().getListeners(RetryReadListener.class, this.step, injectionRef2, this.jobExecutionImpl);
        List<RetryWriteListener> retryWriteListeners = this.jobExecutionImpl.getListenerFactory().getListeners(RetryWriteListener.class, this.step, injectionRef2, this.jobExecutionImpl);
        this.skipHandler = new SkipHandler(this.chunk);
        this.skipHandler.addSkipProcessListener(skipProcessListeners);
        this.skipHandler.addSkipReadListener(skipReadListeners);
        this.skipHandler.addSkipWriteListener(skipWriteListeners);
        this.retryHandler = new RetryHandler(this.chunk);
        this.retryHandler.addRetryProcessListener(retryProcessListeners);
        this.retryHandler.addRetryReadListener(retryReadListeners);
        this.retryHandler.addRetryWriteListener(retryWriteListeners);
    }

    private void setNextChunkTransactionTimeout() {
        int nextTimeout = 0;
        nextTimeout = this.customCheckpointPolicy ? this.checkpointManager.checkpointTimeout() : this.stepPropertyTranTimeoutSeconds;
        this.transactionManager.setTransactionTimeout(nextTimeout);
    }

    private int initStepTransactionTimeout() {
        Properties p = this.stepContext.getProperties();
        int timeout = 180;
        if (p != null && !p.isEmpty()) {
            String propertyTimeOut = p.getProperty("javax.transaction.global.timeout");
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "javax.transaction.global.timeout = {0}", propertyTimeOut == null ? "<null>" : propertyTimeOut);
            }
            if (propertyTimeOut != null && !propertyTimeOut.isEmpty()) {
                timeout = Integer.parseInt(propertyTimeOut, 10);
            }
        }
        return timeout;
    }

    private void openReaderAndWriter() {
        block15: {
            block14: {
                this.readerChkptDK = new CheckpointDataKey(this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId(), CheckpointType.READER);
                CheckpointData readerChkptData = this.persistenceManagerService.getCheckpointData(this.readerChkptDK);
                try {
                    if (readerChkptData != null) {
                        byte[] readertoken = readerChkptData.getRestartToken();
                        try {
                            this.readerProxy.open((Serializable)this.dataRepresentationService.toJavaRepresentation(readertoken));
                            break block14;
                        }
                        catch (Exception ex) {
                            throw new BatchContainerServiceException("Cannot read the checkpoint data for [" + this.step.getId() + "]", ex);
                        }
                    }
                    readerChkptData = null;
                    try {
                        this.readerProxy.open(null);
                    }
                    catch (Exception ex) {
                        throw new BatchContainerServiceException("Exception while opening step [" + this.step.getId() + "]", ex);
                    }
                }
                catch (ClassCastException e) {
                    throw new IllegalStateException("Expected CheckpointData but found" + readerChkptData);
                }
            }
            this.writerChkptDK = new CheckpointDataKey(this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId(), CheckpointType.WRITER);
            CheckpointData writerChkptData = this.persistenceManagerService.getCheckpointData(this.writerChkptDK);
            try {
                if (writerChkptData != null) {
                    byte[] writertoken = writerChkptData.getRestartToken();
                    try {
                        this.writerProxy.open((Serializable)this.dataRepresentationService.toJavaRepresentation(writertoken));
                        break block15;
                    }
                    catch (Exception ex) {
                        throw new BatchContainerServiceException("Cannot persist the checkpoint data for [" + this.step.getId() + "]", ex);
                    }
                }
                writerChkptData = null;
                try {
                    this.writerProxy.open(null);
                }
                catch (Exception e) {
                    ExceptionConfig.wrapBatchException(e);
                }
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Expected Checkpoint but found" + writerChkptData);
            }
        }
    }

    @Override
    public void stop() {
        this.stepContext.setBatchStatus(BatchStatus.STOPPING);
    }

    private boolean skipReadException(Exception e) {
        try {
            this.skipHandler.handleExceptionRead(e);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    private boolean retryReadException(Exception e) {
        try {
            this.retryHandler.handleExceptionRead(e);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    private boolean skipProcessException(Exception e, Object record) {
        try {
            this.skipHandler.handleExceptionWithRecordProcess(e, record);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    private boolean retryProcessException(Exception e, Object record) {
        try {
            this.retryHandler.handleExceptionProcess(e, record);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    private boolean skipWriteException(Exception e, List<Object> chunkToWrite) {
        try {
            this.skipHandler.handleExceptionWithRecordListWrite(e, chunkToWrite);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    private boolean retryWriteException(Exception e, List<Object> chunkToWrite) {
        try {
            this.retryHandler.handleExceptionWrite(e, chunkToWrite);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    private void positionReaderAtCheckpoint() {
        block7: {
            this.readerChkptDK = new CheckpointDataKey(this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId(), CheckpointType.READER);
            CheckpointData readerData = this.persistenceManagerService.getCheckpointData(this.readerChkptDK);
            try {
                if (readerData != null) {
                    byte[] readertoken = readerData.getRestartToken();
                    try {
                        this.readerProxy.open((Serializable)this.dataRepresentationService.toJavaRepresentation(readertoken));
                        break block7;
                    }
                    catch (Exception ex) {
                        throw new BatchContainerServiceException("Cannot persist the checkpoint data for [" + this.step.getId() + "]", ex);
                    }
                }
                readerData = null;
                try {
                    this.readerProxy.open(null);
                }
                catch (Exception ex) {
                    throw new BatchContainerServiceException("Cannot persist the checkpoint data for [" + this.step.getId() + "]", ex);
                }
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Expected CheckpointData but found" + readerData);
            }
        }
    }

    private void positionWriterAtCheckpoint() {
        block7: {
            this.writerChkptDK = new CheckpointDataKey(this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId(), CheckpointType.WRITER);
            CheckpointData writerData = this.persistenceManagerService.getCheckpointData(this.writerChkptDK);
            try {
                if (writerData != null) {
                    byte[] writertoken = writerData.getRestartToken();
                    try {
                        this.writerProxy.open((Serializable)this.dataRepresentationService.toJavaRepresentation(writertoken));
                        break block7;
                    }
                    catch (Exception ex) {
                        throw new BatchContainerServiceException("Cannot read the checkpoint data for [" + this.step.getId() + "]", ex);
                    }
                }
                writerData = null;
                try {
                    this.writerProxy.open(null);
                }
                catch (Exception ex) {
                    throw new BatchContainerServiceException("Cannot open the step [" + this.step.getId() + "]", ex);
                }
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Expected CheckpointData but found" + writerData);
            }
        }
    }

    private class ChunkStatus {
        ChunkStatusType type;
        private boolean finished = false;
        private Exception retryableException = null;
        private boolean markedForRollbackWithRetry = false;
        private int itemsTouchedInCurrentChunk = 0;
        private int itemsToProcessOneByOneAfterRollback = 0;

        ChunkStatus() {
            this(ChunkStatusType.NORMAL);
        }

        ChunkStatus(ChunkStatusType type) {
            this.type = type;
        }

        public boolean isRetryingAfterRollback() {
            return this.type == ChunkStatusType.RETRY_AFTER_ROLLBACK;
        }

        public boolean wasMarkedForRollbackWithRetry() {
            return this.markedForRollbackWithRetry;
        }

        public Exception getRetryableException() {
            return this.retryableException;
        }

        public void markForRollbackWithRetry(Exception retryableException) {
            this.markedForRollbackWithRetry = true;
            this.retryableException = retryableException;
        }

        public int getItemsTouchedInCurrentChunk() {
            return this.itemsTouchedInCurrentChunk;
        }

        public void incrementItemsTouchedInCurrentChunk() {
            ++this.itemsTouchedInCurrentChunk;
        }

        public int getItemsToProcessOneByOneAfterRollback() {
            return this.itemsToProcessOneByOneAfterRollback;
        }

        public void setItemsToProcessOneByOneAfterRollback(int itemsToProcessOneByOneAfterRollback) {
            this.itemsToProcessOneByOneAfterRollback = itemsToProcessOneByOneAfterRollback;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void setFinished(boolean finished) {
            this.finished = finished;
        }
    }

    private static enum ChunkStatusType {
        NORMAL,
        RETRY_AFTER_ROLLBACK;

    }

    private class SingleItemStatus {
        private boolean skipped = false;
        private boolean filtered = false;

        private SingleItemStatus() {
        }

        public boolean isSkipped() {
            return this.skipped;
        }

        public void setSkipped(boolean skipped) {
            this.skipped = skipped;
        }

        public boolean isFiltered() {
            return this.filtered;
        }

        public void setFiltered(boolean filtered) {
            this.filtered = filtered;
        }
    }
}

