/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.metrics.common;

import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.geronimo.microprofile.metrics.common.CounterImpl;
import org.apache.geronimo.microprofile.metrics.common.HistogramImpl;
import org.apache.geronimo.microprofile.metrics.common.MeterImpl;
import org.apache.geronimo.microprofile.metrics.common.TimerImpl;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Timer;

public class RegistryImpl
extends MetricRegistry {
    private final ConcurrentMap<String, Holder<? extends Metric>> metrics = new ConcurrentHashMap<String, Holder<? extends Metric>>();

    public <T extends Metric> T register(Metadata metadata, T metric) throws IllegalArgumentException {
        Holder holder = this.metrics.putIfAbsent(metadata.getName(), new Holder(metric, metadata, null));
        if (holder != null && !metadata.isReusable() && !holder.metadata.isReusable()) {
            throw new IllegalArgumentException("'" + metadata.getName() + "' metric already exists and is not reusable");
        }
        return metric;
    }

    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        MetricType type = Counter.class.isInstance(metric) ? MetricType.COUNTER : (Gauge.class.isInstance(metric) ? MetricType.GAUGE : (Meter.class.isInstance(metric) ? MetricType.METERED : (Timer.class.isInstance(metric) ? MetricType.TIMER : (Histogram.class.isInstance(metric) ? MetricType.HISTOGRAM : MetricType.INVALID))));
        return this.register(new Metadata(name, type), metric);
    }

    public <T extends Metric> T register(String name, T metric, Metadata metadata) throws IllegalArgumentException {
        return this.register(metadata, metric);
    }

    public Counter counter(Metadata metadata) {
        Holder holder = (Holder)this.metrics.get(metadata.getName());
        if (holder == null) {
            holder = new Holder((Metric)new CounterImpl(metadata.getUnit()), metadata, null);
            Holder existing = this.metrics.putIfAbsent(metadata.getName(), holder);
            if (existing != null) {
                holder = existing;
            }
        } else {
            if (!metadata.isReusable()) {
                throw new IllegalArgumentException("Metric " + metadata.getName() + " already exists and is not set as reusable");
            }
            if (!holder.metadata.isReusable()) {
                throw new IllegalArgumentException("Metric " + metadata.getName() + " already exists and was not set as reusable");
            }
        }
        if (!Counter.class.isInstance(holder.metric)) {
            throw new IllegalArgumentException(holder.metric + " is not a counter");
        }
        return (Counter)Counter.class.cast(holder.metric);
    }

    public Histogram histogram(Metadata metadata) {
        Holder holder = (Holder)this.metrics.get(metadata.getName());
        if (holder == null) {
            holder = new Holder((Metric)new HistogramImpl(metadata.getUnit()), metadata, null);
            Holder existing = this.metrics.putIfAbsent(metadata.getName(), holder);
            if (existing != null) {
                holder = existing;
            }
        } else {
            if (!metadata.isReusable()) {
                throw new IllegalArgumentException("Metric " + metadata.getName() + " already exists and is not set as reusable");
            }
            if (!holder.metadata.isReusable()) {
                throw new IllegalArgumentException("Metric " + metadata.getName() + " already exists and was not set as reusable");
            }
        }
        if (!Histogram.class.isInstance(holder.metric)) {
            throw new IllegalArgumentException(holder.metric + " is not a histogram");
        }
        return (Histogram)Histogram.class.cast(holder.metric);
    }

    public Meter meter(Metadata metadata) {
        Holder holder = (Holder)this.metrics.get(metadata.getName());
        if (holder == null) {
            holder = new Holder((Metric)new MeterImpl(metadata.getUnit()), metadata, null);
            Holder existing = this.metrics.putIfAbsent(metadata.getName(), holder);
            if (existing != null) {
                holder = existing;
            }
        } else {
            if (!metadata.isReusable()) {
                throw new IllegalArgumentException("Metric " + metadata.getName() + " already exists and is not set as reusable");
            }
            if (!holder.metadata.isReusable()) {
                throw new IllegalArgumentException("Metric " + metadata.getName() + " already exists and was not set as reusable");
            }
        }
        if (!Meter.class.isInstance(holder.metric)) {
            throw new IllegalArgumentException(holder.metric + " is not a meter");
        }
        return (Meter)Meter.class.cast(holder.metric);
    }

    public Timer timer(Metadata metadata) {
        Holder holder = (Holder)this.metrics.get(metadata.getName());
        if (holder == null) {
            holder = new Holder((Metric)new TimerImpl(metadata.getUnit()), metadata, null);
            Holder existing = this.metrics.putIfAbsent(metadata.getName(), holder);
            if (existing != null) {
                holder = existing;
            }
        } else {
            if (!metadata.isReusable()) {
                throw new IllegalArgumentException("Metric " + metadata.getName() + " already exists and is not set as reusable");
            }
            if (!holder.metadata.isReusable()) {
                throw new IllegalArgumentException("Metric " + metadata.getName() + " already exists and was not set as reusable");
            }
        }
        if (!Timer.class.isInstance(holder.metric)) {
            throw new IllegalArgumentException(holder.metric + " is not a timer");
        }
        return (Timer)Timer.class.cast(holder.metric);
    }

    public Counter counter(String name) {
        return this.counter(new Metadata(name, MetricType.COUNTER));
    }

    public Histogram histogram(String name) {
        return this.histogram(new Metadata(name, MetricType.HISTOGRAM));
    }

    public Meter meter(String name) {
        return this.meter(new Metadata(name, MetricType.METERED));
    }

    public Timer timer(String name) {
        return this.timer(new Metadata(name, MetricType.TIMER));
    }

    public boolean remove(String name) {
        return this.metrics.remove(name) != null;
    }

    public void removeMatching(MetricFilter filter) {
        this.metrics.entrySet().removeIf(it -> filter.matches((String)it.getKey(), ((Holder)it.getValue()).metric));
    }

    public SortedSet<String> getNames() {
        return new TreeSet<String>(this.metrics.keySet());
    }

    public SortedMap<String, Gauge> getGauges() {
        return this.getGauges(MetricFilter.ALL);
    }

    public SortedMap<String, Gauge> getGauges(MetricFilter filter) {
        return this.filterByType(filter, Gauge.class);
    }

    public SortedMap<String, Counter> getCounters() {
        return this.getCounters(MetricFilter.ALL);
    }

    public SortedMap<String, Counter> getCounters(MetricFilter filter) {
        return this.filterByType(filter, Counter.class);
    }

    public SortedMap<String, Histogram> getHistograms() {
        return this.getHistograms(MetricFilter.ALL);
    }

    public SortedMap<String, Histogram> getHistograms(MetricFilter filter) {
        return this.filterByType(filter, Histogram.class);
    }

    public SortedMap<String, Meter> getMeters() {
        return this.getMeters(MetricFilter.ALL);
    }

    public SortedMap<String, Meter> getMeters(MetricFilter filter) {
        return this.filterByType(filter, Meter.class);
    }

    public SortedMap<String, Timer> getTimers() {
        return this.getTimers(MetricFilter.ALL);
    }

    public SortedMap<String, Timer> getTimers(MetricFilter filter) {
        return this.filterByType(filter, Timer.class);
    }

    public Map<String, Metric> getMetrics() {
        return this.metrics.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Holder)e.getValue()).metric));
    }

    public Map<String, Metadata> getMetadata() {
        return this.metrics.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Holder)e.getValue()).metadata));
    }

    private <T extends Metric> SortedMap<String, T> filterByType(MetricFilter filter, Class<T> type) {
        return this.metrics.entrySet().stream().filter(it -> type.isInstance(((Holder)it.getValue()).metric)).filter(it -> filter.matches((String)it.getKey(), ((Holder)it.getValue()).metric)).collect(Collectors.toMap(Map.Entry::getKey, e -> (Metric)type.cast(((Holder)e.getValue()).metric), (a, b) -> {
            throw new IllegalArgumentException("can't merge metrics");
        }, TreeMap::new));
    }

    private static final class Holder<T extends Metric> {
        private final T metric;
        private final Metadata metadata;

        private Holder(T metric, Metadata metadata) {
            this.metric = metric;
            this.metadata = new Metadata(metadata.getName(), metadata.getDisplayName(), metadata.getDescription(), metadata.getTypeRaw(), metadata.getUnit());
            this.metadata.setReusable(metadata.isReusable());
            this.metadata.setTags(metadata.getTags());
        }

        /* synthetic */ Holder(Metric x0, Metadata x1, 1 x2) {
            this(x0, x1);
        }
    }
}

