/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.metrics;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import javax.annotation.Priority;
import javax.enterprise.inject.spi.CDI;
import org.apache.safeguard.impl.config.GeronimoFaultToleranceConfig;
import org.apache.safeguard.impl.metrics.MicroprofileMetricsImpl;
import org.apache.safeguard.impl.metrics.NoMetrics;
import org.eclipse.microprofile.metrics.MetricRegistry;

public interface FaultToleranceMetrics {
    public Counter counter(String var1, String var2);

    public void gauge(String var1, String var2, String var3, Supplier<Long> var4);

    public Histogram histogram(String var1, String var2);

    public static FaultToleranceMetrics create(GeronimoFaultToleranceConfig config) {
        if ("false".equalsIgnoreCase(config.read("MP_Fault_Tolerance_Metrics_Enabled"))) {
            return new NoMetrics();
        }
        try {
            Optional<FaultToleranceMetrics> iterator = StreamSupport.stream(ServiceLoader.load(FaultToleranceMetrics.class).spliterator(), false).min(Comparator.comparing(it -> Optional.ofNullable(it.getClass().getAnnotation(Priority.class)).map(Priority::value).orElse(0)));
            if (iterator.isPresent()) {
                return iterator.orElseThrow(IllegalStateException::new);
            }
            return new MicroprofileMetricsImpl((MetricRegistry)CDI.current().select(MetricRegistry.class, new Annotation[0]).get());
        }
        catch (Exception exception) {
            return new NoMetrics();
        }
    }

    public static interface Gauge
    extends Supplier<Long> {
    }

    public static interface Counter {
        public void inc();

        public void dec();
    }

    public static interface Histogram {
        public void update(long var1);
    }
}

