/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.interceptor.InvocationContext;
import org.apache.safeguard.impl.asynchronous.AsynchronousInterceptor;
import org.apache.safeguard.impl.bulkhead.BulkheadInterceptor;
import org.apache.safeguard.impl.cdi.FallbackBinding;
import org.apache.safeguard.impl.cdi.PriorityBinding;
import org.apache.safeguard.impl.cdi.SafeguardEnabled;
import org.apache.safeguard.impl.circuitbreaker.CircuitBreakerInterceptor;
import org.apache.safeguard.impl.config.GeronimoFaultToleranceConfig;
import org.apache.safeguard.impl.customizable.Safeguard;
import org.apache.safeguard.impl.fallback.FallbackInterceptor;
import org.apache.safeguard.impl.metrics.FaultToleranceMetrics;
import org.apache.safeguard.impl.retry.AfterRetryInterceptor;
import org.apache.safeguard.impl.retry.BaseRetryInterceptor;
import org.apache.safeguard.impl.retry.BeforeRetryInterceptor;
import org.apache.safeguard.impl.timeout.TimeoutInterceptor;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

public class SafeguardExtension
implements Extension {
    private boolean foundExecutor;
    private GeronimoFaultToleranceConfig config;
    private Integer priorityBase;
    private final Collection<Annotated> beansToValidate = new ArrayList<Annotated>();
    private TimeoutInterceptor.Cache timeoutCache;
    private BulkheadInterceptor.Cache bulkHeadCache;
    private CircuitBreakerInterceptor.Cache circuitBreakerCache;
    private FallbackInterceptor.Cache fallbackCache;
    private BaseRetryInterceptor.Cache retryCache;

    void grabInterceptorPriority(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.config = GeronimoFaultToleranceConfig.create();
        this.priorityBase = Optional.ofNullable(this.config.read("mp.fault.tolerance.interceptor.priority")).map(Integer::parseInt).orElse(null);
    }

    void customizeAsyncPriority(@Observes ProcessAnnotatedType<AsynchronousInterceptor> interceptor) {
        this.customizePriority(interceptor);
    }

    void customizeBulkHeadPriority(@Observes ProcessAnnotatedType<BulkheadInterceptor> interceptor) {
        this.customizePriority(interceptor);
    }

    void customizeCircuitbreakerPriority(@Observes ProcessAnnotatedType<CircuitBreakerInterceptor> interceptor) {
        this.customizePriority(interceptor);
    }

    void customizeFallbackPriority(@Observes ProcessAnnotatedType<FallbackInterceptor> interceptor) {
        this.customizePriority(interceptor);
    }

    void customizeBeforeRetryPriority(@Observes ProcessAnnotatedType<BeforeRetryInterceptor> interceptor) {
        this.customizePriority(interceptor);
    }

    void customizeAfterRetryPriority(@Observes ProcessAnnotatedType<AfterRetryInterceptor> interceptor) {
        this.customizePriority(interceptor);
    }

    void customizeTimeoutPriority(@Observes ProcessAnnotatedType<TimeoutInterceptor> interceptor) {
        this.customizePriority(interceptor);
    }

    void addFallbackInterceptor(@Observes ProcessAnnotatedType<FallbackInterceptor> processAnnotatedType) {
        processAnnotatedType.configureAnnotatedType().add((Annotation)((Object)new FallbackBinding()));
    }

    void activateSafeguard(@Observes @WithAnnotations(value={Bulkhead.class, CircuitBreaker.class, Fallback.class, Retry.class, Timeout.class}) ProcessAnnotatedType<?> processAnnotatedType) {
        if (processAnnotatedType.getAnnotatedType().getJavaClass().getName().startsWith("org.apache.safeguard.impl.")) {
            return;
        }
        if (this.faultToleranceAnnotations().anyMatch(it -> processAnnotatedType.getAnnotatedType().isAnnotationPresent(it))) {
            processAnnotatedType.configureAnnotatedType().add((Annotation)SafeguardEnabled.Literal.INSTANCE);
        } else {
            List methods = processAnnotatedType.getAnnotatedType().getMethods().stream().filter(it -> this.faultToleranceAnnotations().anyMatch(arg_0 -> ((AnnotatedMethod)it).isAnnotationPresent(arg_0))).map(AnnotatedMethod::getJavaMember).collect(Collectors.toList());
            processAnnotatedType.configureAnnotatedType().filterMethods(it -> methods.contains(it.getJavaMember())).forEach(m -> m.add((Annotation)SafeguardEnabled.Literal.INSTANCE));
        }
    }

    void onBean(@Observes ProcessBean<?> bean) {
        AnnotatedType at;
        if (this.isSafeguardBean(bean) && bean.getBean().getTypes().stream().anyMatch(it -> Executor.class.isAssignableFrom(this.toClass((Type)it)))) {
            this.foundExecutor = true;
        }
        if (AnnotatedType.class.isInstance(bean.getAnnotated()) && (at = (AnnotatedType)AnnotatedType.class.cast(bean.getAnnotated())).getMethods().stream().anyMatch(m -> m.isAnnotationPresent(SafeguardEnabled.class))) {
            this.beansToValidate.add(bean.getAnnotated());
        }
    }

    void addMissingBeans(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        GeronimoFaultToleranceConfig config = GeronimoFaultToleranceConfig.create();
        afterBeanDiscovery.addBean().id("geronimo_safeguard#configuration").types(new Type[]{GeronimoFaultToleranceConfig.class, Object.class}).beanClass(GeronimoFaultToleranceConfig.class).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(c -> config);
        afterBeanDiscovery.addBean().id("geronimo_safeguard#metrics").types(new Type[]{FaultToleranceMetrics.class, Object.class}).beanClass(FaultToleranceMetrics.class).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(c -> FaultToleranceMetrics.create(config));
        if (!this.foundExecutor) {
            afterBeanDiscovery.addBean().id("geronimo_safeguard#executor").types(new Type[]{Executor.class, Object.class}).beanClass(Executor.class).qualifiers(new Annotation[]{Safeguard.Literal.INSTANCE, Any.Literal.INSTANCE}).createWith(c -> Executors.newCachedThreadPool(new ThreadFactory(){
                private final ThreadGroup group = Optional.ofNullable(System.getSecurityManager()).map(SecurityManager::getThreadGroup).orElseGet(() -> Thread.currentThread().getThreadGroup());
                private final String prefix = "org.apache.geronimo.safeguard.asynchronous@" + System.identityHashCode(this);
                private final AtomicLong counter = new AtomicLong();

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(this.group, r, this.prefix + this.counter.incrementAndGet());
                }
            })).scope(ApplicationScoped.class).destroyWith((e, c) -> ((ExecutorService)ExecutorService.class.cast(e)).shutdownNow());
        }
    }

    void addDefinitionErrors(@Observes AfterDeploymentValidation validation) {
        this.beansToValidate.stream().map(this::validate).filter(Objects::nonNull).forEach(arg_0 -> ((AfterDeploymentValidation)validation).addDeploymentProblem(arg_0));
        this.beansToValidate.clear();
    }

    private <T> T getInstance(Class<T> cache) {
        return (T)CDI.current().select(cache, new Annotation[0]).get();
    }

    private Throwable validate(Annotated annotated) {
        Throwable throwable = this.validate(Timeout.class, annotated, context -> {
            if (this.timeoutCache == null) {
                this.timeoutCache = this.getInstance(TimeoutInterceptor.Cache.class);
            }
            this.timeoutCache.create((InvocationContext)context);
        });
        if (throwable != null) {
            return throwable;
        }
        throwable = this.validate(Bulkhead.class, annotated, context -> {
            if (this.bulkHeadCache == null) {
                this.bulkHeadCache = this.getInstance(BulkheadInterceptor.Cache.class);
            }
            this.bulkHeadCache.create((InvocationContext)context);
        });
        if (throwable != null) {
            return throwable;
        }
        throwable = this.validate(CircuitBreaker.class, annotated, context -> {
            if (this.circuitBreakerCache == null) {
                this.circuitBreakerCache = this.getInstance(CircuitBreakerInterceptor.Cache.class);
            }
            this.circuitBreakerCache.create((InvocationContext)context);
        });
        if (throwable != null) {
            return throwable;
        }
        throwable = this.validate(Fallback.class, annotated, context -> {
            if (this.fallbackCache == null) {
                this.fallbackCache = this.getInstance(FallbackInterceptor.Cache.class);
            }
            this.fallbackCache.create((InvocationContext)context);
        });
        if (throwable != null) {
            return throwable;
        }
        throwable = this.validate(Retry.class, annotated, context -> {
            if (this.retryCache == null) {
                this.retryCache = this.getInstance(BaseRetryInterceptor.Cache.class);
            }
            this.retryCache.create((InvocationContext)context);
        });
        if (throwable != null) {
            return throwable;
        }
        return null;
    }

    private Throwable validate(Class<? extends Annotation> marker, Annotated type, Consumer<InvocationContext> contextConsumer) {
        boolean classHasMarker = type.isAnnotationPresent(marker);
        AnnotatedType annotatedType = (AnnotatedType)AnnotatedType.class.cast(type);
        try {
            annotatedType.getMethods().stream().filter(it -> classHasMarker || it.isAnnotationPresent(marker)).map(m -> new MockInvocationContext(m.getJavaMember())).forEach(contextConsumer);
            return null;
        }
        catch (RuntimeException re) {
            return new DefinitionException((Throwable)re);
        }
    }

    private boolean isSafeguardBean(ProcessBean<?> bean) {
        return bean.getBean().getQualifiers().stream().anyMatch(it -> it.annotationType() == Safeguard.class);
    }

    private void customizePriority(ProcessAnnotatedType<?> type) {
        if (this.priorityBase == null) {
            return;
        }
        int offset = ((Priority)type.getAnnotatedType().getAnnotation(Priority.class)).value() - 4000;
        type.configureAnnotatedType().remove(it -> it.annotationType() == Priority.class).add((Annotation)((Object)new PriorityBinding(this.priorityBase + offset)));
    }

    public Class<?> toClass(Type it) {
        return this.doToClass(it, 0);
    }

    private Class<?> doToClass(Type it, int iterations) {
        if (Class.class.isInstance(it)) {
            return (Class)Class.class.cast(it);
        }
        if (iterations > 100) {
            return Object.class;
        }
        if (ParameterizedType.class.isInstance(it)) {
            return this.doToClass(((ParameterizedType)ParameterizedType.class.cast(it)).getRawType(), iterations + 1);
        }
        return Object.class;
    }

    private Stream<Class<? extends Annotation>> faultToleranceAnnotations() {
        return Stream.of(Asynchronous.class, Bulkhead.class, CircuitBreaker.class, Fallback.class, Retry.class, Timeout.class);
    }

    private static class MockInvocationContext
    implements InvocationContext {
        private static final Object[] NO_PARAM = new Object[0];
        private final Method method;

        private MockInvocationContext(Method m) {
            this.method = m;
        }

        public Object getTarget() {
            return null;
        }

        public Method getMethod() {
            return this.method;
        }

        public Constructor<?> getConstructor() {
            return null;
        }

        public Object[] getParameters() {
            return NO_PARAM;
        }

        public void setParameters(Object[] parameters) {
        }

        public Map<String, Object> getContextData() {
            return Collections.emptyMap();
        }

        public Object proceed() {
            return null;
        }

        public Object getTimer() {
            return null;
        }
    }
}

