/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.openapi.impl.filter;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.tags.Tag;

public class FilterImpl {
    private final OASFilter delegate;

    public FilterImpl(OASFilter delegate) {
        this.delegate = delegate;
    }

    public OpenAPI filter(OpenAPI api) {
        Optional.ofNullable(api.getComponents()).ifPresent(this::filterComponents);
        Optional.ofNullable(api.getPaths()).ifPresent(paths -> paths.forEach((k, v) -> {
            Optional.ofNullable(v.readOperationsMap()).ifPresent(operations -> {
                operations.entrySet().stream().filter((? super T it) -> it.getValue() != null).filter((? super T it) -> this.delegate.filterOperation((Operation)it.getValue()) == null).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(operations::remove);
                operations.values().stream().filter(Objects::nonNull).forEach(this::filterOperation);
            });
            paths.entrySet().stream().filter((? super T it) -> this.delegate.filterPathItem((PathItem)it.getValue()) == null).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(arg_0 -> ((Paths)paths).remove(arg_0));
            Optional.ofNullable(v.getParameters()).ifPresent(this::filterParameters);
            Optional.ofNullable(v.getServers()).ifPresent(this::filterServers);
        }));
        Optional.ofNullable(api.getServers()).ifPresent(this::filterServers);
        Optional.ofNullable(api.getTags()).ifPresent(this::filterTags);
        this.delegate.filterOpenAPI(api);
        return api;
    }

    private void filterOperation(Operation op) {
        Optional.ofNullable(op.getServers()).ifPresent(this::filterServers);
        Optional.ofNullable(op.getRequestBody()).ifPresent(it -> {
            if (this.delegate.filterRequestBody(it) == null) {
                op.requestBody(null);
            }
        });
        Optional.ofNullable(op.getParameters()).ifPresent(this::filterParameters);
        Optional.ofNullable(op.getCallbacks()).ifPresent(this::filterCallbacks);
        Optional.ofNullable(op.getResponses()).ifPresent(responses -> responses.forEach((rk, response) -> {
            Optional.ofNullable(response.getLinks()).ifPresent(this::filterLinks);
            Optional.ofNullable(response.getContent()).ifPresent(contents -> contents.values().forEach(content -> Optional.ofNullable(content.getSchema()).ifPresent(schema -> {
                if (this.delegate.filterSchema(schema) == null) {
                    content.setSchema(null);
                }
            })));
            responses.entrySet().stream().filter((? super T it) -> this.delegate.filterAPIResponse((APIResponse)it.getValue()) == null).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(arg_0 -> ((APIResponses)responses).remove(arg_0));
        }));
    }

    private void filterComponents(Components components) {
        Optional.ofNullable(components.getCallbacks()).ifPresent(this::filterCallbacks);
        Optional.ofNullable(components.getHeaders()).ifPresent(headers -> headers.entrySet().stream().filter((? super T it) -> this.delegate.filterHeader((Header)it.getValue()) == null).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(headers::remove));
        Optional.ofNullable(components.getLinks()).ifPresent(this::filterLinks);
        Optional.ofNullable(components.getParameters()).ifPresent(parameters -> parameters.entrySet().stream().filter((? super T it) -> this.delegate.filterParameter((Parameter)it.getValue()) == null).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(parameters::remove));
        Optional.ofNullable(components.getRequestBodies()).ifPresent(requestBodies -> requestBodies.entrySet().stream().filter((? super T it) -> this.delegate.filterRequestBody((RequestBody)it.getValue()) == null).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(requestBodies::remove));
        Optional.ofNullable(components.getResponses()).ifPresent(responses -> responses.entrySet().stream().filter((? super T it) -> this.delegate.filterAPIResponse((APIResponse)it.getValue()) == null).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(responses::remove));
        Optional.ofNullable(components.getSchemas()).ifPresent(schemas -> schemas.entrySet().stream().filter((? super T it) -> this.delegate.filterSchema((Schema)it.getValue()) == null).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(schemas::remove));
        Optional.ofNullable(components.getSecuritySchemes()).ifPresent(schemes -> schemes.entrySet().stream().filter((? super T it) -> this.delegate.filterSecurityScheme((SecurityScheme)it.getValue()) == null).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(schemes::remove));
    }

    private void filterLinks(Map<String, Link> links) {
        links.entrySet().stream().filter((? super T it) -> this.delegate.filterLink((Link)it.getValue()) == null).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(links::remove);
    }

    private void filterCallbacks(Map<String, Callback> callbacks) {
        callbacks.entrySet().stream().filter((? super T it) -> this.delegate.filterCallback((Callback)it.getValue()) == null).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(callbacks::remove);
    }

    private void filterTags(List<Tag> tags) {
        tags.stream().filter((? super T it) -> this.delegate.filterTag(it) == null).collect(Collectors.toList()).forEach(tags::remove);
    }

    private void filterParameters(List<Parameter> parameters) {
        parameters.stream().filter((? super T it) -> this.delegate.filterParameter(it) == null).collect(Collectors.toList()).forEach(parameters::remove);
    }

    private void filterServers(List<Server> servers) {
        servers.stream().filter((? super T it) -> this.delegate.filterServer(it) == null).collect(Collectors.toList()).forEach(servers::remove);
    }
}

