/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELProcessor;
import javax.enterprise.inject.spi.BeanManager;

public class TomEEELInvocationHandler
implements InvocationHandler {
    private static final Pattern EL_EXPRESSION_PATTERN = Pattern.compile("^[#$]\\{(.+)}$");
    private final Annotation annotation;
    private final ELProcessor processor;

    public TomEEELInvocationHandler(Annotation annotation, ELProcessor processor) {
        this.annotation = annotation;
        this.processor = processor;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String sanitizedExpression;
        if (method.getName().endsWith("Expression") && method.getReturnType().equals(String.class)) {
            return method.invoke((Object)this.annotation, args);
        }
        if (!method.getReturnType().equals(String.class)) {
            try {
                Method expressionMethod = this.annotation.getClass().getDeclaredMethod(method.getName() + "Expression", method.getParameterTypes());
                String expression = (String)expressionMethod.invoke(proxy, args);
                if (!expression.trim().isEmpty()) {
                    return TomEEELInvocationHandler.eval(this.processor, TomEEELInvocationHandler.sanitizeExpression(expression), method.getReturnType());
                }
                return method.invoke((Object)this.annotation, args);
            }
            catch (NoSuchMethodException e) {
                return method.invoke((Object)this.annotation, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        String value = (String)method.invoke((Object)this.annotation, args);
        if (value != null && value.length() > 3 && !value.equals(sanitizedExpression = TomEEELInvocationHandler.sanitizeExpression(value))) {
            return TomEEELInvocationHandler.eval(this.processor, sanitizedExpression, method.getReturnType());
        }
        return value;
    }

    public static boolean isExpression(String rawExpression) {
        Matcher matcher = EL_EXPRESSION_PATTERN.matcher(rawExpression);
        return matcher.matches();
    }

    public static String sanitizeExpression(String rawExpression) {
        Matcher matcher = EL_EXPRESSION_PATTERN.matcher(rawExpression);
        if (!matcher.matches()) {
            return rawExpression;
        }
        return matcher.replaceAll("$1");
    }

    public static Object eval(ELProcessor processor, String sanitizedExpression, Class<?> expectedType) {
        Class<?> enumType;
        if (!TomEEELInvocationHandler.isEnumOrArrayOfEnums(expectedType)) {
            return processor.getValue(sanitizedExpression, expectedType);
        }
        Object value = processor.getValue(sanitizedExpression, Object.class);
        if (expectedType.isEnum() && value instanceof String) {
            return TomEEELInvocationHandler.of(expectedType, value);
        }
        if (expectedType.isArray() && value instanceof String && (enumType = expectedType.getComponentType()).isEnum()) {
            Enum enumConstant = (Enum)TomEEELInvocationHandler.of(enumType, value);
            Enum[] outcomeArray = (Enum[])Array.newInstance(enumType, 1);
            outcomeArray[0] = enumConstant;
            return outcomeArray;
        }
        return value;
    }

    private static boolean isEnumOrArrayOfEnums(Class type) {
        if (type.isEnum()) {
            return true;
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            return componentType.isEnum();
        }
        return false;
    }

    private static <T> T of(Class<T> type, Object name) {
        try {
            return (T)type.getDeclaredMethod("valueOf", String.class).invoke(null, name);
        }
        catch (Exception e) {
            return (T)name;
        }
    }

    public static <T extends Annotation> T of(Class<T> annotationClass, T annotation, BeanManager beanManager) {
        ELProcessor elProcessor = new ELProcessor();
        elProcessor.getELManager().addELResolver(beanManager.getELResolver());
        return TomEEELInvocationHandler.of(annotationClass, annotation, elProcessor);
    }

    public static <T extends Annotation> T of(Class<T> annotationClass, T annotation, ELProcessor elProcessor) {
        return (T)((Annotation)Proxy.newProxyInstance(annotation.getClass().getClassLoader(), new Class[]{annotationClass}, (InvocationHandler)new TomEEELInvocationHandler(annotation, elProcessor)));
    }
}

