/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.sys;

import java.util.Objects;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.openejb.config.Service;
import org.apache.openejb.config.sys.PropertiesAdapter;
import org.apache.openejb.util.SuperProperties;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Service")
public abstract class AbstractService
implements Service {
    @XmlValue
    @XmlJavaTypeAdapter(value=PropertiesAdapter.class)
    protected Properties properties;
    @XmlAttribute(required=true)
    protected String id;
    @XmlAttribute
    protected String jar;
    @XmlAttribute
    protected String provider;
    @XmlAttribute
    protected String type;
    @XmlAttribute
    protected String classpath;
    @XmlAttribute(name="classpath-api")
    protected String classpathAPI;
    @XmlAttribute(name="class-name")
    protected String className;
    @XmlAttribute(name="constructor")
    protected String constructor;
    @XmlAttribute(name="factory-name")
    protected String factoryName;
    @XmlAttribute(name="properties-provider")
    private String propertiesProvider;
    @XmlAttribute(name="template")
    private String template;

    protected AbstractService(String id) {
        this(id, null, null);
    }

    protected AbstractService(String id, String type) {
        this.id = id;
        this.type = type;
    }

    protected AbstractService(String id, String type, String provider) {
        this.id = id;
        this.provider = provider;
        this.type = type;
    }

    protected AbstractService() {
    }

    @Override
    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new SuperProperties();
        }
        return this.properties;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        this.id = value;
    }

    @Override
    public String getJar() {
        return this.jar;
    }

    @Override
    public void setJar(String value) {
        this.jar = value;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(String value) {
        this.provider = value;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public String getClasspathAPI() {
        return this.classpathAPI;
    }

    public void setClasspathAPI(String classpathAPI) {
        this.classpathAPI = classpathAPI;
    }

    @Override
    public String getConstructor() {
        return this.constructor;
    }

    public void setConstructor(String constructor) {
        this.constructor = constructor;
    }

    @Override
    public String getFactoryName() {
        return this.factoryName;
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }

    @Override
    public String getClasspath() {
        return this.classpath;
    }

    @Override
    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    @Override
    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractService)) {
            return false;
        }
        AbstractService that = (AbstractService)o;
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.jar, that.jar)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.provider, that.provider)) {
            return false;
        }
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        int result = this.properties != null ? this.properties.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.jar != null ? this.jar.hashCode() : 0);
        result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public void setPropertiesProvider(String propertiesProvider) {
        this.propertiesProvider = propertiesProvider;
    }

    @Override
    public String getPropertiesProvider() {
        return this.propertiesProvider;
    }
}

