/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.Metric;
import javax.batch.runtime.context.StepContext;
import org.apache.batchee.container.impl.MetricImpl;

public class StepContextImpl
implements StepContext {
    private String stepId = null;
    private BatchStatus batchStatus = null;
    private String exitStatus = null;
    private Object transientUserData = null;
    private Serializable persistentUserData = null;
    private Exception exception = null;
    private Timestamp starttime = null;
    private Timestamp endtime = null;
    private long stepExecID = Integer.MIN_VALUE;
    private long stepInternalExecID = 0L;
    private final Properties properties = new Properties();
    private String batchletProcessRetVal = null;
    private final ConcurrentHashMap<String, Metric> metrics = new ConcurrentHashMap();

    public StepContextImpl(String stepId) {
        this.stepId = stepId;
    }

    public BatchStatus getBatchStatus() {
        return this.batchStatus;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public String getExitStatus() {
        return this.exitStatus;
    }

    public String getStepName() {
        return this.stepId;
    }

    public Metric[] getMetrics() {
        Collection<Metric> values = this.metrics.values();
        return values.toArray(new Metric[values.size()]);
    }

    public Map<String, Metric> metricsAsMap() {
        for (Metric.MetricType type : Metric.MetricType.values()) {
            this.metrics.putIfAbsent(type.name(), new MetricImpl(type, 0L));
        }
        return Collections.unmodifiableMap(this.metrics);
    }

    public MetricImpl getMetric(Metric.MetricType metricType) {
        return (MetricImpl)this.metrics.get(metricType.name());
    }

    public void addMetric(Metric.MetricType metricType, long value) {
        this.metrics.putIfAbsent(metricType.name(), new MetricImpl(metricType, value));
    }

    public Serializable getPersistentUserData() {
        return this.persistentUserData;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Object getTransientUserData() {
        return this.transientUserData;
    }

    public void setExitStatus(String status) {
        this.exitStatus = status;
    }

    public void setBatchStatus(BatchStatus status) {
        this.batchStatus = status;
    }

    public void setPersistentUserData(Serializable data) {
        this.persistentUserData = data;
    }

    public void setTransientUserData(Object data) {
        this.transientUserData = data;
    }

    public String toString() {
        return " stepId: " + this.stepId + ", batchStatus: " + this.batchStatus + ", exitStatus: " + this.exitStatus + ", batchletProcessRetVal: " + this.batchletProcessRetVal + ", transientUserData: " + this.transientUserData + ", persistentUserData: " + this.persistentUserData;
    }

    public long getStepExecutionId() {
        return this.stepExecID;
    }

    public long getStepInternalExecID() {
        return this.stepInternalExecID;
    }

    public void setStepExecutionId(long stepExecutionId) {
        if (this.stepExecID == Integer.MIN_VALUE) {
            this.stepExecID = stepExecutionId;
        }
    }

    public void setInternalStepExecutionId(long stepExecutionId) {
        this.stepInternalExecID = stepExecutionId;
    }

    public void setStartTime(Timestamp startTS) {
        this.starttime = startTS;
    }

    public void setEndTime(Timestamp endTS) {
        this.endtime = endTS;
    }

    public Timestamp getStartTimeTS() {
        return this.starttime;
    }

    public Timestamp getEndTimeTS() {
        return this.endtime;
    }

    public String getBatchletProcessRetVal() {
        return this.batchletProcessRetVal;
    }

    public void setBatchletProcessRetVal(String batchletProcessRetVal) {
        this.batchletProcessRetVal = batchletProcessRetVal;
    }
}

