/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.metrics.cdi;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import javax.annotation.Priority;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.geronimo.microprofile.metrics.cdi.Names;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Counted;

@Counted
@Interceptor
@Priority(value=1000)
public class CountedInterceptor
implements Serializable {
    @Inject
    private MetricRegistry registry;
    @Inject
    @Intercepted
    private Bean<?> bean;
    @Inject
    private BeanManager beanManager;
    private volatile transient ConcurrentMap<Executable, Meta> counters = new ConcurrentHashMap<Executable, Meta>();

    @AroundConstruct
    public Object onConstructor(InvocationContext context) throws Exception {
        return this.invoke(context, context.getConstructor());
    }

    @AroundInvoke
    public Object onMethod(InvocationContext context) throws Exception {
        return this.invoke(context, context.getMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invoke(InvocationContext context, Executable executable) throws Exception {
        Meta counter = this.findCounter(executable);
        counter.counter.inc();
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            if (!counter.skipDecrement) {
                counter.counter.dec();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Meta findCounter(Executable executable) {
        Meta meta;
        if (this.counters == null) {
            CountedInterceptor countedInterceptor = this;
            synchronized (countedInterceptor) {
                if (this.counters == null) {
                    this.counters = new ConcurrentHashMap<Executable, Meta>();
                }
            }
        }
        if ((meta = (Meta)this.counters.get(executable)) == null) {
            AnnotatedType type = this.beanManager.createAnnotatedType(this.bean.getBeanClass());
            Counted counted = Stream.concat(type.getMethods().stream(), type.getConstructors().stream()).filter(it -> it.getJavaMember().equals(executable)).findFirst().map(m -> (Counted)m.getAnnotation(Counted.class)).orElse(null);
            String name = Names.findName(Modifier.isAbstract(executable.getDeclaringClass().getModifiers()) ? type.getJavaClass() : executable.getDeclaringClass(), executable, counted == null ? null : counted.name(), counted != null && counted.absolute(), Optional.ofNullable(type.getAnnotation(Counted.class)).map(Counted::name).orElse(""));
            Counter counter = (Counter)Counter.class.cast(this.registry.getMetrics().get(name));
            if (counter == null) {
                throw new IllegalStateException("No counter with name [" + name + "] found in registry [" + this.registry + "]");
            }
            meta = new Meta(counter, Optional.ofNullable(counted).orElseGet(() -> (Counted)type.getAnnotation(Counted.class)).monotonic());
            this.counters.putIfAbsent(executable, meta);
        }
        return meta;
    }

    private static final class Meta {
        private final Counter counter;
        private final boolean skipDecrement;

        private Meta(Counter counter, boolean skipDecrement) {
            this.counter = counter;
            this.skipDecrement = skipDecrement;
        }
    }
}

