/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.metrics.common.jaxrs;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.geronimo.microprofile.metrics.common.jaxrs.SecurityValidator;
import org.apache.geronimo.microprofile.metrics.common.prometheus.PrometheusFormatter;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;

@Path(value="metrics")
public class MetricsEndpoints {
    private MetricRegistry baseRegistry;
    private MetricRegistry vendorRegistry;
    private MetricRegistry applicationRegistry;
    private SecurityValidator securityValidator = new SecurityValidator(){
        {
            this.init();
        }
    };
    private PrometheusFormatter prometheus = new PrometheusFormatter().enableOverriding();

    public void setBaseRegistry(MetricRegistry baseRegistry) {
        this.baseRegistry = baseRegistry;
    }

    public void setVendorRegistry(MetricRegistry vendorRegistry) {
        this.vendorRegistry = vendorRegistry;
    }

    public void setApplicationRegistry(MetricRegistry applicationRegistry) {
        this.applicationRegistry = applicationRegistry;
    }

    public void setSecurityValidator(SecurityValidator securityValidator) {
        this.securityValidator = securityValidator;
    }

    public void setPrometheus(PrometheusFormatter prometheus) {
        this.prometheus = prometheus;
    }

    @GET
    @Produces(value={"application/json"})
    public Object getJson(@Context SecurityContext securityContext, @Context UriInfo uriInfo) {
        this.securityValidator.checkSecurity(securityContext, uriInfo);
        return Stream.of(MetricRegistry.Type.values()).collect(Collectors.toMap(MetricRegistry.Type::getName, it -> this.findRegistry(it.getName()).getMetrics().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, m -> this.map((Metric)m.getValue())))));
    }

    @GET
    @Produces(value={"text/plain"})
    public String getText(@Context SecurityContext securityContext, @Context UriInfo uriInfo) {
        this.securityValidator.checkSecurity(securityContext, uriInfo);
        return Stream.of(MetricRegistry.Type.values()).map((? super T type) -> {
            MetricRegistry metricRegistry = this.findRegistry(type.getName());
            return this.prometheus.toText(metricRegistry, type.getName(), metricRegistry.getMetrics());
        }).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
    }

    @GET
    @Path(value="{registry}")
    @Produces(value={"application/json"})
    public Object getJson(@PathParam(value="registry") String registry, @Context SecurityContext securityContext, @Context UriInfo uriInfo) {
        this.securityValidator.checkSecurity(securityContext, uriInfo);
        return this.findRegistry(registry).getMetrics().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> this.map((Metric)it.getValue())));
    }

    @GET
    @Path(value="{registry}")
    @Produces(value={"text/plain"})
    public String getText(@PathParam(value="registry") String registry, @Context SecurityContext securityContext, @Context UriInfo uriInfo) {
        this.securityValidator.checkSecurity(securityContext, uriInfo);
        MetricRegistry metricRegistry = this.findRegistry(registry);
        return this.prometheus.toText(metricRegistry, registry, metricRegistry.getMetrics()).toString();
    }

    @GET
    @Path(value="{registry}/{metric}")
    @Produces(value={"application/json"})
    public Object getJson(@PathParam(value="registry") String registry, @PathParam(value="metric") String name, @Context SecurityContext securityContext, @Context UriInfo uriInfo) {
        this.securityValidator.checkSecurity(securityContext, uriInfo);
        return this.singleEntry(name, this.findRegistry(registry), this::map);
    }

    @GET
    @Path(value="{registry}/{metric}")
    @Produces(value={"text/plain"})
    public String getText(@PathParam(value="registry") String registry, @PathParam(value="metric") String name, @Context SecurityContext securityContext, @Context UriInfo uriInfo) {
        this.securityValidator.checkSecurity(securityContext, uriInfo);
        MetricRegistry metricRegistry = this.findRegistry(registry);
        return this.prometheus.toText(metricRegistry, registry, this.singleEntry(name, metricRegistry, Function.identity())).toString();
    }

    @OPTIONS
    @Path(value="{registry}/{metric}")
    @Produces(value={"application/json"})
    public Object getMetadata(@PathParam(value="registry") String registry, @PathParam(value="metric") String name, @Context SecurityContext securityContext, @Context UriInfo uriInfo) {
        this.securityValidator.checkSecurity(securityContext, uriInfo);
        return Optional.ofNullable(this.findRegistry(registry).getMetadata().get(name)).map((? super T metric) -> Collections.singletonMap(name, this.mapMeta((Metadata)metric))).orElse(Collections.emptyMap());
    }

    @OPTIONS
    @Path(value="{registry}")
    @Produces(value={"application/json"})
    public Object getMetadata(@PathParam(value="registry") String registry, @Context SecurityContext securityContext, @Context UriInfo uriInfo) {
        this.securityValidator.checkSecurity(securityContext, uriInfo);
        return this.findRegistry(registry).getMetadata().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.mapMeta((Metadata)e.getValue())));
    }

    private <T> Map<String, T> singleEntry(String name, MetricRegistry metricRegistry, Function<Metric, T> metricMapper) {
        return Optional.ofNullable(metricRegistry.getMetrics().get(name)).map((? super T metric) -> Collections.singletonMap(name, metricMapper.apply((Metric)metric))).orElseGet(Collections::emptyMap);
    }

    private Meta mapMeta(Metadata value) {
        return Optional.ofNullable(value).map((? super T x$0) -> new Meta((Metadata)x$0)).orElse(null);
    }

    private Object map(Metric metric) {
        if (Counter.class.isInstance(metric)) {
            return ((Counter)Counter.class.cast(metric)).getCount();
        }
        if (Gauge.class.isInstance(metric)) {
            return ((Gauge)Gauge.class.cast(metric)).getValue();
        }
        return metric;
    }

    private MetricRegistry findRegistry(String registry) {
        switch (Stream.of(MetricRegistry.Type.values()).filter(it -> it.getName().equals(registry)).findFirst().orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND))) {
            case BASE: {
                return this.baseRegistry;
            }
            case VENDOR: {
                return this.vendorRegistry;
            }
        }
        return this.applicationRegistry;
    }

    public static class Meta {
        private final Metadata value;

        private Meta(Metadata value) {
            this.value = value;
        }

        public String getName() {
            return this.value.getName();
        }

        public String getDisplayName() {
            return this.value.getDisplayName();
        }

        public String getDescription() {
            return this.value.getDescription();
        }

        public String getType() {
            return this.value.getType();
        }

        public String getTypeRaw() {
            return this.value.getTypeRaw().name();
        }

        public String getUnit() {
            return this.value.getUnit();
        }

        public boolean isReusable() {
            return this.value.isReusable();
        }

        public String getTags() {
            return this.value.getTags().entrySet().stream().map(e -> (String)e.getKey() + '=' + (String)e.getValue()).collect(Collectors.joining(","));
        }
    }
}

