/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.DelegatingInputStream;
import org.apache.cxf.jaxrs.impl.AbstractRequestContextImpl;
import org.apache.cxf.jaxrs.impl.RequestImpl;
import org.apache.cxf.jaxrs.impl.SecurityContextImpl;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.SecurityContext;

public class ContainerRequestContextImpl
extends AbstractRequestContextImpl
implements ContainerRequestContext {
    private static final String ENDPOINT_ADDRESS_PROPERTY = "org.apache.cxf.transport.endpoint.address";
    private boolean preMatch;

    public ContainerRequestContextImpl(Message message, boolean preMatch, boolean responseContext) {
        super(message, responseContext);
        this.preMatch = preMatch;
    }

    public InputStream getEntityStream() {
        return this.m.getContent(InputStream.class);
    }

    public Request getRequest() {
        return new RequestImpl(this.m);
    }

    public javax.ws.rs.core.SecurityContext getSecurityContext() {
        javax.ws.rs.core.SecurityContext sc = this.m.get(javax.ws.rs.core.SecurityContext.class);
        return sc == null ? new SecurityContextImpl(this.m) : sc;
    }

    public UriInfo getUriInfo() {
        return new UriInfoImpl(this.m);
    }

    public boolean hasEntity() {
        InputStream is = this.getEntityStream();
        if (is == null) {
            return false;
        }
        if (HttpUtils.isPayloadEmpty(this.getHeaders())) {
            return false;
        }
        if (is instanceof DelegatingInputStream) {
            ((DelegatingInputStream)is).cacheInput();
        }
        try {
            return !IOUtils.isEmpty(is);
        }
        catch (IOException ex) {
            throw ExceptionUtils.toInternalServerErrorException(ex, null);
        }
    }

    public void setEntityStream(InputStream is) {
        this.checkContext();
        this.m.setContent(InputStream.class, is);
    }

    public MultivaluedMap<String, String> getHeaders() {
        this.h = null;
        return HttpUtils.getModifiableStringHeaders(this.m);
    }

    public void setRequestUri(URI requestUri) throws IllegalStateException {
        if (requestUri.isAbsolute()) {
            String baseUriString = new UriInfoImpl(this.m).getBaseUri().toString();
            String requestUriString = requestUri.toString();
            if (!requestUriString.startsWith(baseUriString)) {
                this.setRequestUri(requestUri, URI.create("/"));
                return;
            }
            if ((requestUriString = requestUriString.substring(baseUriString.length())).isEmpty()) {
                requestUriString = "/";
            }
            requestUri = URI.create(requestUriString);
        }
        this.doSetRequestUri(requestUri);
    }

    protected void doSetRequestUri(URI requestUri) throws IllegalStateException {
        this.checkNotPreMatch();
        HttpUtils.resetRequestURI(this.m, requestUri.getRawPath());
        String query = requestUri.getRawQuery();
        if (query != null) {
            this.m.put(Message.QUERY_STRING, query);
        }
    }

    public void setRequestUri(URI baseUri, URI requestUri) throws IllegalStateException {
        this.doSetRequestUri(requestUri);
        Object servletRequest = this.m.get("HTTP.REQUEST");
        if (servletRequest != null) {
            ((HttpServletRequest)servletRequest).setAttribute(ENDPOINT_ADDRESS_PROPERTY, (Object)baseUri.toString());
        }
    }

    public void setSecurityContext(javax.ws.rs.core.SecurityContext sc) {
        this.checkContext();
        this.m.put(javax.ws.rs.core.SecurityContext.class, sc);
        if (sc instanceof SecurityContext) {
            this.m.put(SecurityContext.class, (SecurityContext)sc);
        }
    }

    private void checkNotPreMatch() {
        if (!this.preMatch) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void setMethod(String method) throws IllegalStateException {
        this.checkNotPreMatch();
        super.setMethod(method);
    }
}

