/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.identitystore;

import java.security.Permission;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.credential.UsernamePasswordCredential;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.IdentityStore;
import javax.security.enterprise.identitystore.IdentityStorePermission;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.deploy.NamingResourcesImpl;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.apache.tomee.loader.TomcatHelper;
import org.apache.tomee.security.cdi.TomcatUserIdentityStoreDefinition;

@ApplicationScoped
public class TomEEDefaultIdentityStore
implements IdentityStore {
    @Inject
    private Supplier<TomcatUserIdentityStoreDefinition> definitionSupplier;
    private TomcatUserIdentityStoreDefinition definition;
    private UserDatabase userDatabase;

    @PostConstruct
    private void init() throws Exception {
        this.definition = this.definitionSupplier.get();
        StandardServer server = TomcatHelper.getServer();
        NamingResourcesImpl resources = server.getGlobalNamingResources();
        ContextResource userDataBaseResource = resources.findResource(this.definition.resource());
        this.userDatabase = (UserDatabase)server.getGlobalNamingContext().lookup(userDataBaseResource.getName());
    }

    public CredentialValidationResult validate(Credential credential) {
        if (!(credential instanceof UsernamePasswordCredential)) {
            return CredentialValidationResult.NOT_VALIDATED_RESULT;
        }
        UsernamePasswordCredential usernamePasswordCredential = (UsernamePasswordCredential)credential;
        User user = this.getUser(usernamePasswordCredential.getCaller());
        if (user == null) {
            return CredentialValidationResult.INVALID_RESULT;
        }
        if (user.getPassword().equals(usernamePasswordCredential.getPasswordAsString())) {
            Set groups = Collections.emptySet();
            if (this.validationTypes().contains(IdentityStore.ValidationType.PROVIDE_GROUPS)) {
                groups = new HashSet<String>(this.getUserRoles(user));
            }
            return new CredentialValidationResult(usernamePasswordCredential.getCaller(), groups);
        }
        return CredentialValidationResult.NOT_VALIDATED_RESULT;
    }

    private User getUser(String callerPrincipal) {
        return this.userDatabase.findUser(callerPrincipal);
    }

    public Set<String> getCallerGroups(CredentialValidationResult validationResult) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission((Permission)new IdentityStorePermission("getGroups"));
        }
        User user = this.getUser(validationResult.getCallerPrincipal().getName());
        return this.getUserRoles(user);
    }

    private Set<String> getUserRoles(User user) {
        if (user == null) {
            return Collections.emptySet();
        }
        HashSet<String> roles = new HashSet<String>();
        user.getRoles().forEachRemaining(role -> roles.add(role.getRolename()));
        return roles;
    }
}

