/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.cdi;

import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.security.enterprise.AuthenticationException;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.authentication.mechanism.http.AutoApplySession;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.security.enterprise.authentication.mechanism.http.LoginToContinue;
import javax.security.enterprise.identitystore.IdentityStoreHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomee.security.http.LoginToContinueMechanism;

@ApplicationScoped
@AutoApplySession
@LoginToContinue
public class CustomFormAuthenticationMechanism
implements HttpAuthenticationMechanism,
LoginToContinueMechanism {
    @Inject
    private Supplier<LoginToContinue> loginToContinue;
    @Inject
    private IdentityStoreHandler identityStoreHandler;

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        if (this.validateCredentials(httpMessageContext)) {
            return httpMessageContext.notifyContainerAboutLogin(this.identityStoreHandler.validate(httpMessageContext.getAuthParameters().getCredential()));
        }
        return httpMessageContext.doNothing();
    }

    @Override
    public LoginToContinue getLoginToContinue() {
        return this.loginToContinue.get();
    }

    private boolean validateCredentials(HttpMessageContext httpMessageContext) {
        return httpMessageContext.getAuthParameters().getCredential() != null;
    }
}

