/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.safeguard.impl.cache.Key;
import org.apache.safeguard.impl.cache.UnwrappedCache;
import org.apache.safeguard.impl.cdi.SafeguardEnabled;
import org.apache.safeguard.impl.metrics.FaultToleranceMetrics;

@Interceptor
@SafeguardEnabled
@Priority(value=0)
public class IdGeneratorInterceptor
implements Serializable {
    private final AtomicLong idGenerator = new AtomicLong();
    @Inject
    private Cache cache;

    @AroundInvoke
    public Object generateId(InvocationContext context) throws Exception {
        Counters existing;
        long id = this.idGenerator.incrementAndGet();
        context.getContextData().put(IdGeneratorInterceptor.class.getName(), id);
        Map<Key, Counters> counters = this.cache.getCounters();
        Key key = new Key(context, this.cache.getUnwrappedCache().getUnwrappedCache());
        Counters methodCounters = counters.get(key);
        if (methodCounters == null && (existing = counters.putIfAbsent(key, methodCounters = this.cache.create(context.getMethod()))) != null) {
            methodCounters = existing;
        }
        methodCounters.total.inc();
        try {
            Object proceed = context.proceed();
            if (CompletionStage.class.isInstance(proceed)) {
                Counters countersRef = methodCounters;
                CompletionStage completionStage = (CompletionStage)CompletionStage.class.cast(proceed);
                return completionStage.exceptionally(e -> {
                    countersRef.failed.inc();
                    if (RuntimeException.class.isInstance(e)) {
                        throw (RuntimeException)RuntimeException.class.cast(e);
                    }
                    if (Error.class.isInstance(e)) {
                        throw (Error)Error.class.cast(e);
                    }
                    throw new IllegalStateException((Throwable)e);
                });
            }
            return proceed;
        }
        catch (Error | Exception e2) {
            methodCounters.failed.inc();
            throw e2;
        }
    }

    @ApplicationScoped
    public static class Cache {
        private final Map<Key, Counters> counters = new ConcurrentHashMap<Key, Counters>();
        @Inject
        private FaultToleranceMetrics metrics;
        @Inject
        private UnwrappedCache unwrappedCache;

        public UnwrappedCache getUnwrappedCache() {
            return this.unwrappedCache;
        }

        public Map<Key, Counters> getCounters() {
            return this.counters;
        }

        public Counters create(Method method) {
            String metricsNameBase = "ft." + method.getDeclaringClass().getCanonicalName() + "." + method.getName() + ".invocations.";
            return new Counters(this.metrics.counter(metricsNameBase + "total", "The number of times the method was called"), this.metrics.counter(metricsNameBase + "failed.total", "The number of times the method was called and, after all Fault Tolerance actions had been processed, threw a Throwable"));
        }
    }

    private static class Counters {
        private final FaultToleranceMetrics.Counter total;
        private final FaultToleranceMetrics.Counter failed;

        private Counters(FaultToleranceMetrics.Counter total, FaultToleranceMetrics.Counter failed) {
            this.total = total;
            this.failed = failed;
        }
    }
}

