/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.openapi.impl.loader.yaml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.NumberSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.stream.Stream;
import javax.enterprise.inject.Vetoed;
import javax.json.JsonNumber;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.bind.annotation.JsonbProperty;
import javax.json.bind.annotation.JsonbTransient;
import org.apache.geronimo.microprofile.openapi.impl.loader.ApiBindings;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;

@Vetoed
public final class Yaml {
    private Yaml() {
    }

    public static OpenAPI loadAPI(InputStream stream) {
        try {
            ObjectMapper mapper = Yaml.getObjectMapper();
            return (OpenAPI)mapper.readValue(stream, OpenAPI.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ObjectMapper getObjectMapper() {
        SimpleAbstractTypeResolver resolver = new SimpleAbstractTypeResolver();
        ApiBindings.get().forEach((k, v) -> resolver.addMapping((Class)Class.class.cast(k), v));
        SimpleModule module = new SimpleModule();
        module.setAbstractTypes(resolver);
        module.addDeserializer(Parameter.In.class, (JsonDeserializer)new JsonDeserializer<Parameter.In>(){

            public Parameter.In deserialize(JsonParser p, DeserializationContext ctxt) {
                return Stream.of(Parameter.In.values()).filter(it -> {
                    try {
                        return it.name().equalsIgnoreCase(p.getValueAsString());
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                }).findFirst().orElseThrow(() -> new IllegalArgumentException("No matching In value"));
            }
        });
        module.addDeserializer(Schema.SchemaType.class, (JsonDeserializer)new JsonDeserializer<Schema.SchemaType>(){

            public Schema.SchemaType deserialize(JsonParser p, DeserializationContext ctxt) {
                return Stream.of(Schema.SchemaType.values()).filter(it -> {
                    try {
                        return it.name().equalsIgnoreCase(p.getValueAsString());
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                }).findFirst().orElseThrow(() -> new IllegalArgumentException("No matching SchemaType value"));
            }
        });
        module.addDeserializer(SecurityScheme.Type.class, (JsonDeserializer)new JsonDeserializer<SecurityScheme.Type>(){

            public SecurityScheme.Type deserialize(JsonParser p, DeserializationContext ctxt) {
                return Stream.of(SecurityScheme.Type.values()).filter(it -> {
                    try {
                        return it.name().equalsIgnoreCase(p.getValueAsString());
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                }).findFirst().orElseThrow(() -> new IllegalArgumentException("No matching SecurityScheme.Type value"));
            }
        });
        module.addSerializer(BigDecimal.class, (JsonSerializer)new NumberSerializer(BigDecimal.class){

            public void serialize(Number value, JsonGenerator g, SerializerProvider provider) throws IOException {
                if (BigDecimal.class.isInstance(value) && value.doubleValue() == (double)value.longValue()) {
                    super.serialize((Number)value.longValue(), g, provider);
                } else {
                    super.serialize(value, g, provider);
                }
            }
        });
        module.addSerializer(JsonString.class, (JsonSerializer)new StdScalarSerializer<JsonString>(JsonString.class){

            public void serialize(JsonString value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeString(value.getString());
            }
        });
        module.addSerializer(JsonNumber.class, (JsonSerializer)new StdScalarSerializer<JsonNumber>(JsonNumber.class){

            public void serialize(JsonNumber value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                double v = value.doubleValue();
                if (v == (double)value.intValue()) {
                    gen.writeNumber(value.intValue());
                } else if (v == (double)value.longValue()) {
                    gen.writeNumber(value.longValue());
                } else {
                    gen.writeNumber(v);
                }
            }
        });
        module.addSerializer(JsonValue.class, (JsonSerializer)new StdScalarSerializer<JsonValue>(JsonValue.class){

            public void serialize(JsonValue value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                switch (value.getValueType()) {
                    case TRUE: 
                    case FALSE: {
                        gen.writeBoolean(value.equals(JsonValue.TRUE));
                        break;
                    }
                    case ARRAY: 
                    case OBJECT: {
                        gen.writeTree((TreeNode)new ObjectMapper().readTree(value.toString()));
                        break;
                    }
                }
            }
        });
        Stream.of(SecurityScheme.Type.class, SecurityScheme.In.class, Schema.SchemaType.class, Header.Style.class, Encoding.Style.class, Parameter.Style.class, Parameter.In.class).forEach(it -> Yaml.toStringSerializer(module, it));
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        mapper.registerModule((Module)module);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){

            public Boolean hasAnyGetter(Annotated a) {
                return "getExtensions".equals(a.getName());
            }

            protected boolean _isIgnorable(Annotated a) {
                return super._isIgnorable(a) || a.getAnnotation(JsonbTransient.class) != null;
            }

            public PropertyName findNameForSerialization(Annotated a) {
                return Optional.ofNullable(a.getAnnotation(JsonbProperty.class)).map(JsonbProperty::value).map(PropertyName::new).orElseGet(() -> super.findNameForSerialization(a));
            }

            public PropertyName findNameForDeserialization(Annotated a) {
                return Optional.ofNullable(a.getAnnotation(JsonbProperty.class)).map(JsonbProperty::value).map(PropertyName::new).orElseGet(() -> super.findNameForDeserialization(a));
            }
        });
        mapper.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategy.PropertyNamingStrategyBase(){

            public String translate(String propertyName) {
                return "ref".equals(propertyName) ? "$ref" : propertyName;
            }
        });
        return mapper.setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL);
    }

    private static <T> void toStringSerializer(SimpleModule module, Class<T> it) {
        module.addSerializer(it, new JsonSerializer<T>(){

            public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeString(value.toString());
            }
        });
    }
}

