/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialNotFoundException;
import javax.security.auth.login.LoginException;
import javax.security.jacc.PolicyContextException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Engine;
import org.apache.catalina.Realm;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.openejb.BeanContext;
import org.apache.openejb.core.security.AbstractSecurityService;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.CallerPrincipal;
import org.apache.tomee.catalina.OpenEJBSecurityListener;
import org.apache.tomee.catalina.TomEERealm;
import org.apache.tomee.catalina.TomcatWebAppBuilder;
import org.apache.tomee.loader.TomcatHelper;

public class TomcatSecurityService
extends AbstractSecurityService {
    private static final boolean ONLY_DEFAULT_REALM = "true".equals(SystemInstance.get().getProperty("tomee.realm.only-default", "false"));
    protected static final ThreadLocal<LinkedList<Subject>> RUN_AS_STACK = new ThreadLocal<LinkedList<Subject>>(){

        @Override
        protected LinkedList<Subject> initialValue() {
            return new LinkedList<Subject>();
        }
    };
    private Realm defaultRealm;

    public TomcatSecurityService() {
        StandardServer server = TomcatHelper.getServer();
        for (Service service : server.findServices()) {
            Engine engine;
            if (!(service.getContainer() instanceof Engine) || (engine = service.getContainer()).getRealm() == null) continue;
            this.defaultRealm = engine.getRealm();
            break;
        }
    }

    public boolean isCallerInRole(String role) {
        Principal principal = this.getCallerPrincipal();
        if (TomcatUser.class.isInstance(principal)) {
            if ("**".equals(role)) {
                return true;
            }
            TomcatUser tomcatUser = (TomcatUser)principal;
            GenericPrincipal genericPrincipal = (GenericPrincipal)tomcatUser.getTomcatPrincipal();
            String[] roles = genericPrincipal.getRoles();
            if (roles != null) {
                for (String userRole : roles) {
                    if (!userRole.equals(role)) continue;
                    return true;
                }
            }
            return false;
        }
        return super.isCallerInRole(role);
    }

    public UUID login(String realmName, String username, String password) throws LoginException {
        Realm realm = this.findRealm(realmName);
        if (realm == null) {
            throw new LoginException("No Tomcat realm available");
        }
        Principal principal = realm.authenticate(username, password);
        if (principal == null) {
            throw new CredentialNotFoundException(username);
        }
        Subject subject = this.createSubject(realm, principal);
        return this.registerSubject(subject);
    }

    private Realm findRealm(String realmName) {
        Realm r;
        if (ONLY_DEFAULT_REALM || realmName == null || realmName.isEmpty()) {
            return this.defaultRealm;
        }
        TomcatWebAppBuilder webAppBuilder = (TomcatWebAppBuilder)SystemInstance.get().getComponent(TomcatWebAppBuilder.class);
        if (webAppBuilder != null && (r = webAppBuilder.getRealms().get('/' + realmName)) != null) {
            return r;
        }
        return this.defaultRealm;
    }

    private Subject createSubject(Realm realm, Principal principal) {
        Subject subject = new Subject();
        subject.getPrincipals().add(principal);
        subject.getPrincipals().add(new TomcatUser(realm, principal));
        Principal p = principal;
        if (principal instanceof TomcatUser) {
            p = ((TomcatUser)principal).getTomcatPrincipal();
            subject.getPrincipals().add(p);
        }
        if (p instanceof GenericPrincipal) {
            GenericPrincipal genericPrincipal = (GenericPrincipal)p;
            subject.getPrincipals().add(genericPrincipal.getUserPrincipal());
            subject.getPrivateCredentials().add(p);
        }
        return subject;
    }

    public Set<String> getLogicalRoles(Principal[] principals, Set<String> logicalRoles) {
        LinkedHashSet<String> roles = new LinkedHashSet<String>(logicalRoles.size());
        block0: for (String logicalRole : logicalRoles) {
            for (Principal principal : principals) {
                String name;
                if (principal instanceof TomcatUser) {
                    TomcatUser user = (TomcatUser)principal;
                    if (!TomcatHelper.hasRole((Realm)user.getRealm(), (Principal)user.getTomcatPrincipal(), (String)logicalRole)) continue;
                    roles.add(logicalRole);
                    continue block0;
                }
                if (principal == null || !logicalRole.equals(name = principal.getName())) continue;
                roles.add(logicalRole);
            }
        }
        return roles;
    }

    public Principal getCallerPrincipal() {
        AbstractSecurityService.Identity currentIdentity = (AbstractSecurityService.Identity)clientIdentity.get();
        if (currentIdentity != null) {
            Set<Principal> principals = currentIdentity.getSubject().getPrincipals();
            for (Principal principal : principals) {
                if (!principal.getClass().isAnnotationPresent(CallerPrincipal.class)) continue;
                return principal;
            }
            if (!principals.isEmpty()) {
                return principals.iterator().next();
            }
        }
        return super.getCallerPrincipal();
    }

    public Object enterWebApp(Realm realm, Principal principal, String runAs) {
        AbstractSecurityService.Identity newIdentity = null;
        if (principal != null) {
            Subject newSubject = this.createSubject(realm, principal);
            newIdentity = new AbstractSecurityService.Identity(newSubject, null);
        }
        AbstractSecurityService.Identity oldIdentity = (AbstractSecurityService.Identity)clientIdentity.get();
        WebAppState webAppState = new WebAppState(oldIdentity, runAs != null);
        clientIdentity.set(newIdentity);
        if (runAs != null) {
            Subject runAsSubject = this.createRunAsSubject(runAs);
            RUN_AS_STACK.get().addFirst(runAsSubject);
        }
        return webAppState;
    }

    public void onLogout(HttpServletRequest request) {
        Object webappState;
        Request state = OpenEJBSecurityListener.requests.get();
        Object object = webappState = state == null ? null : state.getNote(TomEERealm.SECURITY_NOTE);
        if (webappState != null) {
            this.exitWebApp(webappState);
        } else {
            super.onLogout(request);
        }
    }

    public void exitWebApp(Object state) {
        if (state instanceof WebAppState) {
            WebAppState webAppState = (WebAppState)state;
            if (webAppState.oldIdentity == null) {
                clientIdentity.remove();
            } else {
                clientIdentity.set(webAppState.oldIdentity);
            }
            if (webAppState.hadRunAs) {
                RUN_AS_STACK.get().removeFirst();
            }
        }
    }

    public Subject getRunAsSubject(BeanContext callingBeanContext) {
        Subject runAsSubject = super.getRunAsSubject(callingBeanContext);
        if (runAsSubject != null) {
            return runAsSubject;
        }
        LinkedList<Subject> stack = RUN_AS_STACK.get();
        if (stack.isEmpty()) {
            return null;
        }
        return stack.getFirst();
    }

    protected Subject createRunAsSubject(String role) {
        if (role == null) {
            return null;
        }
        HashSet<RunAsRole> principals = new HashSet<RunAsRole>();
        principals.add(new RunAsRole(role));
        return new Subject(true, principals, new HashSet(), new HashSet());
    }

    protected AbstractSecurityService.SecurityContext getDefaultSecurityContext() {
        Object subjectCallable;
        Request request = OpenEJBSecurityListener.requests.get();
        if (request != null && (subjectCallable = request.getAttribute("javax.security.auth.subject.callable")) != null && Callable.class.isInstance(subjectCallable)) {
            try {
                Subject subject = (Subject)((Callable)Callable.class.cast(subjectCallable)).call();
                return new AbstractSecurityService.SecurityContext(subject);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.getDefaultSecurityContext();
    }

    public boolean supports(String key) throws PolicyContextException {
        return KEYS.contains(key);
    }

    public String[] getKeys() throws PolicyContextException {
        return KEYS.toArray(new String[0]);
    }

    public Object getContext(String key, Object data) throws PolicyContextException {
        switch (key) {
            case "javax.servlet.http.HttpServletRequest": {
                return OpenEJBSecurityListener.requests.get();
            }
            case "javax.security.auth.Subject.container": {
                return this.getSubject();
            }
        }
        throw new PolicyContextException("Handler does not support key: " + key);
    }

    private static class WebAppState
    implements Serializable {
        private final AbstractSecurityService.Identity oldIdentity;
        private final boolean hadRunAs;

        public WebAppState(AbstractSecurityService.Identity oldIdentity, boolean hadRunAs) {
            this.oldIdentity = oldIdentity;
            this.hadRunAs = hadRunAs;
        }
    }

    protected static class RunAsRole
    implements Principal {
        private final String name;

        public RunAsRole(String name) {
            if (name == null) {
                throw new NullPointerException("name is null");
            }
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return "[RunAsRole: " + this.name + "]";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RunAsRole runAsRole = (RunAsRole)o;
            return this.name.equals(runAsRole.name);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }
    }

    @CallerPrincipal
    public static class TomcatUser
    implements Principal {
        private final Realm realm;
        private final Principal tomcatPrincipal;

        public TomcatUser(Realm realm, Principal tomcatPrincipal) {
            if (realm == null) {
                throw new NullPointerException("realm is null");
            }
            if (tomcatPrincipal == null) {
                throw new NullPointerException("tomcatPrincipal is null");
            }
            this.realm = realm;
            this.tomcatPrincipal = tomcatPrincipal;
        }

        public Realm getRealm() {
            return this.realm;
        }

        public Principal getTomcatPrincipal() {
            return this.tomcatPrincipal;
        }

        @Override
        public String getName() {
            return this.tomcatPrincipal.getName();
        }

        @Override
        public String toString() {
            return "[TomcatUser: " + this.tomcatPrincipal + "]";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TomcatUser that = (TomcatUser)o;
            return this.realm.equals(that.realm) && this.tomcatPrincipal.equals(that.tomcatPrincipal);
        }

        @Override
        public int hashCode() {
            int result = this.realm.hashCode();
            result = 31 * result + this.tomcatPrincipal.hashCode();
            return result;
        }
    }
}

