/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.ivm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.rmi.AccessException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.ejb.AccessLocalException;
import javax.ejb.EJBException;
import javax.ejb.EJBTransactionRequiredException;
import javax.ejb.EJBTransactionRolledbackException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TransactionRequiredLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.openejb.BeanContext;
import org.apache.openejb.BeanType;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ThreadContextListener;
import org.apache.openejb.core.ivm.ClientSecurity;
import org.apache.openejb.core.ivm.EjbObjectInputStream;
import org.apache.openejb.core.ivm.IntraVmCopyMonitor;
import org.apache.openejb.core.ivm.IntraVmProxy;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.proxy.LocalBeanProxyFactory;

public abstract class BaseEjbProxyHandler
implements InvocationHandler,
Serializable {
    private static final String OPENEJB_LOCALCOPY = "openejb.localcopy";
    private static final boolean REMOTE_COPY_ENABLED = BaseEjbProxyHandler.parseRemoteCopySetting();
    public final Object deploymentID;
    public final Object primaryKey;
    protected final InterfaceType interfaceType;
    private final ReentrantLock lock = new ReentrantLock();
    public boolean inProxyMap;
    public transient RpcContainer container;
    protected boolean isInvalidReference;
    protected Object clientIdentity;
    private IntraVmCopyMonitor.State strategy = IntraVmCopyMonitor.State.NONE;
    private transient WeakReference<BeanContext> beanContextRef;
    private boolean doIntraVmCopy;
    private boolean doCrossClassLoaderCopy;
    private transient WeakHashMap<Class, Object> interfaces;
    private transient WeakReference<Class> mainInterface;

    public BaseEjbProxyHandler(BeanContext beanContext, Object pk, InterfaceType interfaceType, List<Class> interfaces, Class mainInterface) {
        this.container = (RpcContainer)beanContext.getContainer();
        this.deploymentID = beanContext.getDeploymentID();
        this.interfaceType = interfaceType;
        this.primaryKey = pk;
        this.setBeanContext(beanContext);
        if (interfaces == null || interfaces.size() == 0) {
            InterfaceType objectInterfaceType = interfaceType.isHome() ? interfaceType.getCounterpart() : interfaceType;
            interfaces = new ArrayList<Class>(beanContext.getInterfaces(objectInterfaceType));
        }
        if (mainInterface == null && interfaces.size() == 1) {
            mainInterface = interfaces.get(0);
        }
        this.setInterfaces(interfaces);
        this.setMainInterface(mainInterface);
        if (mainInterface == null) {
            throw new IllegalArgumentException("No mainInterface: otherwise di: " + beanContext + " InterfaceType: " + (Object)((Object)interfaceType) + " interfaces: " + interfaces);
        }
        this.setDoIntraVmCopy(REMOTE_COPY_ENABLED && !interfaceType.isLocal() && !interfaceType.isLocalBean());
    }

    private static boolean parseRemoteCopySetting() {
        return SystemInstance.get().getOptions().get(OPENEJB_LOCALCOPY, true);
    }

    protected void setDoIntraVmCopy(boolean doIntraVmCopy) {
        this.doIntraVmCopy = doIntraVmCopy;
        this.setStrategy();
    }

    protected void setDoCrossClassLoaderCopy(boolean doCrossClassLoaderCopy) {
        this.doCrossClassLoaderCopy = doCrossClassLoaderCopy;
        this.setStrategy();
    }

    private void setStrategy() {
        this.strategy = !this.doIntraVmCopy ? IntraVmCopyMonitor.State.NONE : (this.doCrossClassLoaderCopy ? IntraVmCopyMonitor.State.CLASSLOADER_COPY : IntraVmCopyMonitor.State.COPY);
    }

    protected Class<?> getInvokedInterface(Method method) {
        Class mainInterface = this.getMainInterface();
        if (this.interfaceType.isHome()) {
            return mainInterface;
        }
        if (this.interfaceType.isLocalBean()) {
            return mainInterface;
        }
        Class<?> declaringClass = method.getDeclaringClass();
        if (mainInterface != null && declaringClass.isAssignableFrom(mainInterface)) {
            return mainInterface;
        }
        for (Class secondaryInterface : this.interfaces.keySet()) {
            if (!declaringClass.isAssignableFrom(secondaryInterface)) continue;
            return secondaryInterface;
        }
        throw new IllegalStateException("Received method invocation and cannot determine corresponding business interface: method=" + method);
    }

    public Class getMainInterface() {
        return (Class)this.mainInterface.get();
    }

    private void setMainInterface(Class referent) {
        this.mainInterface = new WeakReference<Class>(referent);
    }

    public List<Class> getInterfaces() {
        Set<Class> classes = this.interfaces.keySet();
        ArrayList<Class> list = new ArrayList<Class>();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        for (Class clazz : classes) {
            if (clazz.isInterface() && this.getBeanContext().getInterfaceType(clazz) == InterfaceType.BUSINESS_REMOTE) {
                try {
                    list.add(contextClassLoader.loadClass(clazz.getName()));
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    list.add(clazz);
                }
                continue;
            }
            list.add(clazz);
        }
        return list;
    }

    private void setInterfaces(List<Class> interfaces) {
        this.interfaces = new WeakHashMap(interfaces.size());
        for (Class clazz : interfaces) {
            this.interfaces.put(clazz, null);
        }
    }

    protected void checkAuthorization(Method method) throws OpenEJBException {
    }

    public void setIntraVmCopyMode(boolean on) {
        this.setDoIntraVmCopy(on);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            this.isValidReference(method);
        }
        catch (IllegalStateException ise) {
            BeanContext beanContext;
            if (method.getName().equals("writeReplace") && (beanContext = (BeanContext)this.beanContextRef.get()) != null) {
                return this._writeReplace(proxy);
            }
            throw ise;
        }
        if (args == null) {
            args = new Object[]{};
        }
        if (method.getDeclaringClass() == Object.class) {
            String methodName = method.getName();
            if (methodName.equals("toString")) {
                return this.toString();
            }
            if (methodName.equals("equals")) {
                return this.equals(args[0]) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (methodName.equals("hashCode")) {
                return this.hashCode();
            }
            throw new UnsupportedOperationException("Unknown method: " + method);
        }
        if (method.getDeclaringClass() == IntraVmProxy.class) {
            String methodName = method.getName();
            if (methodName.equals("writeReplace")) {
                return this._writeReplace(proxy);
            }
            throw new UnsupportedOperationException("Unknown method: " + method);
        }
        if (method.getDeclaringClass() == BeanContext.Removable.class) {
            return this._invoke(proxy, BeanContext.Removable.class, method, args);
        }
        Class<?> interfce = this.getInvokedInterface(method);
        ThreadContext callContext = ThreadContext.getThreadContext();
        Object localClientIdentity = ClientSecurity.getIdentity();
        try {
            if (callContext == null && localClientIdentity != null) {
                SecurityService securityService = SystemInstance.get().getComponent(SecurityService.class);
                securityService.associate(localClientIdentity);
            }
            if (this.strategy == IntraVmCopyMonitor.State.CLASSLOADER_COPY || this.getBeanContext().getInterfaceType(interfce) == InterfaceType.BUSINESS_REMOTE) {
                IntraVmCopyMonitor.pre(this.strategy);
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getBeanContext().getClassLoader());
                try {
                    args = this.copyArgs(args);
                    method = this.copyMethod(method);
                    interfce = this.copyObj(interfce);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                    IntraVmCopyMonitor.post();
                }
            }
            if (this.strategy == IntraVmCopyMonitor.State.COPY && args != null && args.length > 0) {
                IntraVmCopyMonitor.pre(this.strategy);
                try {
                    args = this.copyArgs(args);
                }
                finally {
                    IntraVmCopyMonitor.post();
                }
            }
            IntraVmCopyMonitor.State oldStrategy = this.strategy;
            if (this.getBeanContext().isAsynchronous(method) || this.getBeanContext().getComponentType().equals((Object)BeanType.MANAGED)) {
                this.strategy = IntraVmCopyMonitor.State.NONE;
            }
            try {
                Object returnValue = this._invoke(proxy, interfce, method, args);
                Object object = this.copy(this.strategy, returnValue);
                return object;
            }
            catch (Throwable throwable) {
                throwable = this.copy(this.strategy, throwable);
                throw this.convertException(throwable, method, interfce);
            }
            finally {
                this.strategy = oldStrategy;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (callContext == null && localClientIdentity != null) {
                SecurityService securityService = SystemInstance.get().getComponent(SecurityService.class);
                securityService.disassociate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T copy(IntraVmCopyMonitor.State strategy, T object) throws IOException, ClassNotFoundException {
        if (object == null || !strategy.isCopy()) {
            return object;
        }
        IntraVmCopyMonitor.pre(strategy);
        try {
            T t = this.copyObj(object);
            return t;
        }
        finally {
            IntraVmCopyMonitor.post();
        }
    }

    public boolean isValid() {
        return !this.isInvalidReference;
    }

    private void isValidReference(Method method) throws NoSuchObjectException {
        if (this.isInvalidReference) {
            if (this.interfaceType.isComponent() && this.interfaceType.isLocal()) {
                throw new NoSuchObjectLocalException("reference is invalid");
            }
            if (this.interfaceType.isComponent() || Remote.class.isAssignableFrom(method.getDeclaringClass())) {
                throw new NoSuchObjectException("reference is invalid");
            }
            throw new NoSuchEJBException("reference is invalid for " + this.deploymentID);
        }
        if (!(Object.class.equals(method.getDeclaringClass()) && method.getName().equals("finalize") && method.getExceptionTypes().length == 1 && Throwable.class.equals(method.getExceptionTypes()[0]))) {
            this.getBeanContext();
        }
    }

    protected Throwable convertException(Throwable e, Method method, Class interfce) {
        boolean rmiRemote = Remote.class.isAssignableFrom(interfce);
        if (e instanceof TransactionRequiredException) {
            if (!rmiRemote && this.interfaceType.isBusiness()) {
                return new EJBTransactionRequiredException(e.getMessage()).initCause(this.getCause(e));
            }
            if (this.interfaceType.isLocal()) {
                return new TransactionRequiredLocalException(e.getMessage()).initCause(this.getCause(e));
            }
            return e;
        }
        if (e instanceof TransactionRolledbackException) {
            if (!rmiRemote && this.interfaceType.isBusiness()) {
                return new EJBTransactionRolledbackException(e.getMessage()).initCause(this.getCause(e));
            }
            if (this.interfaceType.isLocal()) {
                return new TransactionRolledbackLocalException(e.getMessage()).initCause(this.getCause(e));
            }
            return e;
        }
        if (e instanceof NoSuchObjectException) {
            if (!rmiRemote && this.interfaceType.isBusiness()) {
                return new NoSuchEJBException(e.getMessage()).initCause(this.getCause(e));
            }
            if (this.interfaceType.isLocal()) {
                return new NoSuchObjectLocalException(e.getMessage()).initCause(this.getCause(e));
            }
            return e;
        }
        if (e instanceof AccessException) {
            if (!rmiRemote && this.interfaceType.isBusiness()) {
                return new AccessLocalException(e.getMessage()).initCause(this.getCause(e));
            }
            if (this.interfaceType.isLocal()) {
                return new AccessLocalException(e.getMessage()).initCause(this.getCause(e));
            }
            return e;
        }
        if (e instanceof RemoteException) {
            if (!rmiRemote && this.interfaceType.isBusiness()) {
                return new EJBException(e.getMessage()).initCause(this.getCause(e));
            }
            if (this.interfaceType.isLocal()) {
                return new EJBException(e.getMessage()).initCause(this.getCause(e));
            }
            return e;
        }
        for (Class<?> type : method.getExceptionTypes()) {
            if (!type.isAssignableFrom(e.getClass())) continue;
            return e;
        }
        while (e.getCause() != null && !(e instanceof RuntimeException)) {
            e = e.getCause();
        }
        return e;
    }

    private Method copyMethod(Method method) throws Exception {
        int parameterCount = method.getParameterTypes().length;
        Object[] types = new Class[1 + parameterCount];
        types[0] = method.getDeclaringClass();
        System.arraycopy(method.getParameterTypes(), 0, types, 1, parameterCount);
        types = (Class[])this.copyArgs(types);
        Object targetClass = types[0];
        Class[] targetParameters = new Class[parameterCount];
        System.arraycopy(types, 1, targetParameters, 0, parameterCount);
        return ((Class)targetClass).getMethod(method.getName(), targetParameters);
    }

    protected Throwable getCause(Throwable e) {
        if (e != null && e.getCause() != null) {
            return e.getCause();
        }
        return e;
    }

    public String toString() {
        String name = null;
        try {
            name = this.getProxyInfo().getInterface().getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "proxy=" + name + ";deployment=" + this.deploymentID + ";pk=" + this.primaryKey;
    }

    public int hashCode() {
        if (this.primaryKey == null) {
            return this.deploymentID.hashCode();
        }
        return this.primaryKey.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!BaseEjbProxyHandler.class.isInstance(obj)) {
            Class<?> aClass = obj.getClass();
            if (Proxy.isProxyClass(aClass)) {
                obj = Proxy.getInvocationHandler(obj);
            } else if (LocalBeanProxyFactory.isProxy(aClass)) {
                obj = LocalBeanProxyFactory.getInvocationHandler(obj);
            } else {
                return false;
            }
        }
        return this.equalHandler((BaseEjbProxyHandler)BaseEjbProxyHandler.class.cast(obj));
    }

    protected boolean equalHandler(BaseEjbProxyHandler other) {
        return (this.primaryKey == null ? other.primaryKey == null : this.primaryKey.equals(other.primaryKey)) && this.deploymentID.equals(other.deploymentID) && this.getMainInterface().equals(other.getMainInterface());
    }

    protected abstract Object _invoke(Object var1, Class var2, Method var3, Object[] var4) throws Throwable;

    protected Object[] copyArgs(Object[] objects) throws IOException, ClassNotFoundException {
        if (objects == null) {
            return objects;
        }
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = this.copyObj(objects[i]);
        }
        return objects;
    }

    protected <T> T copyObj(T object) throws IOException, ClassNotFoundException {
        if (object == null) {
            return null;
        }
        Class<?> ooc = object.getClass();
        if (ooc == Integer.TYPE || ooc == String.class || ooc == Long.TYPE || ooc == Boolean.TYPE || ooc == Byte.TYPE || ooc == Float.TYPE || ooc == Double.TYPE || ooc == Short.TYPE || ooc == Long.class || ooc == Boolean.class || ooc == Byte.class || ooc == Character.class || ooc == Float.class || ooc == Double.class || ooc == Short.class || ooc == BigDecimal.class) {
            return object;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(128);
        try {
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(object);
            out.close();
        }
        catch (NotSerializableException e) {
            throw (IOException)new NotSerializableException(e.getMessage() + " : The EJB specification restricts remote interfaces to only serializable data types.  This can be disabled for in-vm use with the " + OPENEJB_LOCALCOPY + "=false system property.").initCause(e);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        EjbObjectInputStream in = new EjbObjectInputStream(bais);
        Object obj = in.readObject();
        return (T)obj;
    }

    public void invalidateReference() {
        this.container = null;
        this.setBeanContext(null);
        this.isInvalidReference = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateAllHandlers(Object key) {
        HashSet set = (HashSet)this.getLiveHandleRegistry().remove(key);
        if (set == null) {
            return;
        }
        ReentrantLock l = this.lock;
        l.lock();
        try {
            for (BaseEjbProxyHandler handler : set) {
                handler.invalidateReference();
            }
        }
        finally {
            l.unlock();
        }
    }

    protected abstract Object _writeReplace(Object var1) throws ObjectStreamException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerHandler(Object key, BaseEjbProxyHandler handler) {
        Set<BaseEjbProxyHandler> set = (HashSet<BaseEjbProxyHandler>)this.getLiveHandleRegistry().get(key);
        if (set == null) {
            set = new HashSet<BaseEjbProxyHandler>();
            HashSet existing = this.getLiveHandleRegistry().putIfAbsent(key, set);
            if (existing != null) {
                set = (Set)Set.class.cast(existing);
            }
        }
        ReentrantLock l = this.lock;
        l.lock();
        try {
            set.add(handler);
        }
        finally {
            l.unlock();
        }
    }

    public abstract ProxyInfo getProxyInfo();

    public BeanContext getBeanContext() {
        BeanContext beanContext = (BeanContext)this.beanContextRef.get();
        if (beanContext == null || beanContext.isDestroyed()) {
            this.invalidateReference();
            throw new IllegalStateException("Bean '" + this.deploymentID + "' has been undeployed.");
        }
        return beanContext;
    }

    public void setBeanContext(BeanContext beanContext) {
        this.beanContextRef = new WeakReference<BeanContext>(beanContext);
    }

    public ConcurrentMap getLiveHandleRegistry() {
        BeanContext beanContext;
        block8: {
            beanContext = this.getBeanContext();
            ThreadContext tc = ThreadContext.getThreadContext();
            if (tc != null && tc.getBeanContext() != beanContext && tc.getCurrentOperation() == Operation.BUSINESS) {
                ProxyRegistry registry = tc.get(ProxyRegistry.class);
                if (registry == null) {
                    registry = new ProxyRegistry();
                    tc.set(ProxyRegistry.class, registry);
                }
                return registry.liveHandleRegistry;
            }
            SystemInstance systemInstance = SystemInstance.get();
            TransactionManager txMgr = systemInstance.getComponent(TransactionManager.class);
            try {
                String resourceKey;
                Transaction tx = txMgr.getTransaction();
                if (tx == null || tx.getStatus() != 0) break block8;
                TransactionSynchronizationRegistry registry = systemInstance.getComponent(TransactionSynchronizationRegistry.class);
                ConcurrentHashMap map = (ConcurrentHashMap)ConcurrentMap.class.cast(registry.getResource((Object)(resourceKey = ProxyRegistry.class.getName())));
                if (map == null) {
                    map = new ConcurrentHashMap();
                    registry.putResource((Object)resourceKey, map);
                    try {
                        final ConcurrentHashMap tmp = map;
                        tx.registerSynchronization(new Synchronization(){

                            public void beforeCompletion() {
                            }

                            public void afterCompletion(int status) {
                                tmp.clear();
                            }
                        });
                    }
                    catch (RollbackException rollbackException) {
                        // empty catch block
                    }
                }
                return map;
            }
            catch (SystemException tx) {
                // empty catch block
            }
        }
        ProxyRegistry proxyRegistry = beanContext.get(ProxyRegistry.class);
        if (proxyRegistry == null) {
            proxyRegistry = new ProxyRegistry();
            beanContext.set(ProxyRegistry.class, proxyRegistry);
        }
        return proxyRegistry.liveHandleRegistry;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getInterfaces());
        out.writeObject(this.getMainInterface());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        ContainerSystem containerSystem = SystemInstance.get().getComponent(ContainerSystem.class);
        this.setBeanContext(containerSystem.getBeanContext(this.deploymentID));
        this.container = (RpcContainer)this.getBeanContext().getContainer();
        if (IntraVmCopyMonitor.isCrossClassLoaderOperation()) {
            this.setDoCrossClassLoaderCopy(true);
        }
        this.setInterfaces((List)in.readObject());
        this.setMainInterface((Class)in.readObject());
    }

    static {
        ThreadContext.addThreadContextListener(new ThreadContextListener(){

            @Override
            public void contextEntered(ThreadContext oldContext, ThreadContext newContext) {
            }

            @Override
            public void contextExited(ThreadContext exitedContext, ThreadContext reenteredContext) {
                ProxyRegistry proxyRegistry;
                if (exitedContext != null && (proxyRegistry = exitedContext.get(ProxyRegistry.class)) != null) {
                    proxyRegistry.liveHandleRegistry.clear();
                }
            }
        });
    }

    private static class ProxyRegistry {
        protected final ConcurrentMap liveHandleRegistry = new ConcurrentHashMap();

        private ProxyRegistry() {
        }
    }
}

