/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.List;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.BaseConvertDefinitions;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.jee.JMSConnectionFactory;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.KeyedCollection;
import org.apache.openejb.jee.Property;
import org.apache.openejb.util.PropertyPlaceHolderHelper;

public class ConvertJMSConnectionFactoryDefinitions
extends BaseConvertDefinitions {
    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        List<JndiConsumer> jndiConsumers = this.collectConsumers(appModule);
        KeyedCollection factories = new KeyedCollection();
        for (JndiConsumer consumer : jndiConsumers) {
            if (consumer == null) continue;
            factories.addAll(consumer.getJMSConnectionFactories());
        }
        for (JMSConnectionFactory factory : factories) {
            appModule.getResources().add(this.toResource(factory));
        }
        return appModule;
    }

    private Resource toResource(JMSConnectionFactory factory) {
        String name = this.cleanUpName(factory.getName());
        Resource factoryResource = new Resource(name, ConnectionFactory.class.getName());
        factoryResource.setJndi(factory.getName().replaceFirst("java:", ""));
        factoryResource.setType(factory.getInterfaceName() != null && !factory.getInterfaceName().isEmpty() ? factory.getInterfaceName() : "javax.jms.ConnectionFactory");
        if (factory.getClassName() != null && !factory.getClassName().isEmpty()) {
            factoryResource.setClassName(factory.getClassName());
        }
        Properties p = factoryResource.getProperties();
        ConvertJMSConnectionFactoryDefinitions.put(p, "Origin", "Annotation");
        ConvertJMSConnectionFactoryDefinitions.put(p, "JndiName", factoryResource.getJndi());
        if (factory.getResourceAdapter() != null && !factory.getResourceAdapter().isEmpty()) {
            ConvertJMSConnectionFactoryDefinitions.put(p, "ResourceAdapter", factory.getResourceAdapter());
        }
        if (factory.isTransactional()) {
            ConvertJMSConnectionFactoryDefinitions.put(p, "TransactionSupport", "xa");
        } else {
            ConvertJMSConnectionFactoryDefinitions.put(p, "TransactionSupport", "none");
        }
        if (factory.getMaxPoolSize() != null && factory.getMaxPoolSize() > 0) {
            ConvertJMSConnectionFactoryDefinitions.put(p, "PoolMaxSize", factory.getMaxPoolSize());
        }
        if (factory.getMinPoolSize() != null && factory.getMinPoolSize() > 0) {
            ConvertJMSConnectionFactoryDefinitions.put(p, "PoolMinSize", factory.getMinPoolSize());
        }
        if (factory.getUser() != null && !factory.getUser().isEmpty()) {
            ConvertJMSConnectionFactoryDefinitions.put(p, "UserName", factory.getUser());
        }
        if (factory.getPassword() != null && !factory.getPassword().isEmpty()) {
            ConvertJMSConnectionFactoryDefinitions.put(p, "Password", factory.getUser());
        }
        if (factory.getClientId() != null && !factory.getClientId().isEmpty()) {
            ConvertJMSConnectionFactoryDefinitions.put(p, "Clientid", factory.getUser());
        }
        this.setProperties(factory, p);
        return factoryResource;
    }

    private void setProperties(JMSConnectionFactory d, Properties p) {
        for (Property property : d.getProperty()) {
            String key = property.getName();
            String value = property.getValue();
            ConvertJMSConnectionFactoryDefinitions.put(p, key, value);
        }
    }

    private static void put(Properties properties, String key, Object value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            return;
        }
        properties.put(key, PropertyPlaceHolderHelper.value(String.valueOf(value)));
    }
}

