/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.x509;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.cryptacular.x509.ExtensionType;

public final class ExtensionReader {
    private final X509Certificate certificate;

    public ExtensionReader(X509Certificate cert) {
        this.certificate = cert;
    }

    public ASN1Encodable read(String extensionOidOrName) {
        if (extensionOidOrName == null) {
            throw new IllegalArgumentException("extensionOidOrName cannot be null.");
        }
        if (extensionOidOrName.contains(".")) {
            return this.read(ExtensionType.fromOid(extensionOidOrName));
        }
        return this.read(ExtensionType.fromName(extensionOidOrName));
    }

    public ASN1Encodable read(ExtensionType extension) {
        byte[] data = this.certificate.getExtensionValue(extension.getOid());
        if (data == null) {
            return null;
        }
        try {
            ASN1Primitive der = ASN1Primitive.fromByteArray((byte[])data);
            if (der instanceof ASN1OctetString) {
                data = ((ASN1OctetString)der).getOctets();
                der = ASN1Primitive.fromByteArray((byte[])data);
            }
            return der;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IO exception parsing ASN.1 data", e);
        }
    }

    public GeneralNames readSubjectAlternativeName() {
        return GeneralNames.getInstance((Object)this.read(ExtensionType.SubjectAlternativeName));
    }

    public GeneralNames readIssuerAlternativeName() {
        return GeneralNames.getInstance((Object)this.read(ExtensionType.IssuerAlternativeName));
    }

    public BasicConstraints readBasicConstraints() {
        return BasicConstraints.getInstance((Object)this.read(ExtensionType.BasicConstraints));
    }

    public List<PolicyInformation> readCertificatePolicies() {
        ASN1Encodable data = this.read(ExtensionType.CertificatePolicies);
        if (data == null) {
            return null;
        }
        ASN1Sequence sequence = ASN1Sequence.getInstance((Object)data);
        ArrayList<PolicyInformation> list = new ArrayList<PolicyInformation>(sequence.size());
        for (int i = 0; i < sequence.size(); ++i) {
            list.add(PolicyInformation.getInstance((Object)sequence.getObjectAt(i)));
        }
        return list;
    }

    public SubjectKeyIdentifier readSubjectKeyIdentifier() {
        return SubjectKeyIdentifier.getInstance((Object)this.read(ExtensionType.SubjectKeyIdentifier));
    }

    public AuthorityKeyIdentifier readAuthorityKeyIdentifier() {
        return AuthorityKeyIdentifier.getInstance((Object)this.read(ExtensionType.AuthorityKeyIdentifier));
    }

    public KeyUsage readKeyUsage() {
        return KeyUsage.getInstance((Object)this.read(ExtensionType.KeyUsage));
    }

    public List<KeyPurposeId> readExtendedKeyUsage() {
        ASN1Encodable data = this.read(ExtensionType.ExtendedKeyUsage);
        if (data == null) {
            return null;
        }
        ASN1Sequence sequence = ASN1Sequence.getInstance((Object)data);
        ArrayList<KeyPurposeId> list = new ArrayList<KeyPurposeId>(sequence.size());
        for (int i = 0; i < sequence.size(); ++i) {
            list.add(KeyPurposeId.getInstance((Object)sequence.getObjectAt(i)));
        }
        return list;
    }

    public List<DistributionPoint> readCRLDistributionPoints() {
        ASN1Encodable data = this.read(ExtensionType.CRLDistributionPoints);
        if (data == null) {
            return null;
        }
        ASN1Sequence sequence = ASN1Sequence.getInstance((Object)data);
        ArrayList<DistributionPoint> list = new ArrayList<DistributionPoint>(sequence.size());
        for (int i = 0; i < sequence.size(); ++i) {
            list.add(DistributionPoint.getInstance((Object)sequence.getObjectAt(i)));
        }
        return list;
    }

    public List<AccessDescription> readAuthorityInformationAccess() {
        ASN1Encodable data = this.read(ExtensionType.AuthorityInformationAccess);
        if (data == null) {
            return null;
        }
        ASN1Sequence sequence = ASN1Sequence.getInstance((Object)data);
        ArrayList<AccessDescription> list = new ArrayList<AccessDescription>(sequence.size());
        for (int i = 0; i < sequence.size(); ++i) {
            list.add(AccessDescription.getInstance((Object)sequence.getObjectAt(i)));
        }
        return list;
    }
}

