/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.File;
import java.io.IOException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.util.ContextName;

public class Contexts {
    public static String getHostname(StandardContext ctx) {
        String hostName = null;
        Container parentHost = ctx.getParent();
        if (parentHost != null) {
            hostName = parentHost.getName();
        }
        if (hostName == null || hostName.length() < 1) {
            hostName = "_";
        }
        return hostName;
    }

    public static File warPath(Context standardContext) {
        File extracted;
        File file = Contexts.realWarPath(standardContext);
        if (file == null) {
            return null;
        }
        String name = file.getName();
        if (!file.isDirectory() && name.endsWith(".war") && (extracted = new File(file.getParentFile(), name.substring(0, name.length() - ".war".length()))).exists()) {
            try {
                return extracted.getCanonicalFile();
            }
            catch (IOException e) {
                return extracted;
            }
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file;
        }
    }

    public static File realWarPath(Context standardContext) {
        File extracted;
        File docBase;
        File file;
        Context container;
        if (standardContext == null) {
            return null;
        }
        for (container = standardContext; container != null && !(container instanceof Host); container = container.getParent()) {
        }
        String baseName = null;
        if (standardContext.getDocBase() != null) {
            file = new File(standardContext.getDocBase());
            if (!file.isAbsolute()) {
                if (container == null) {
                    docBase = new File(Contexts.engineBase(standardContext), standardContext.getDocBase());
                } else {
                    String appBase = ((Host)container).getAppBase();
                    file = new File(appBase);
                    if (!file.isAbsolute()) {
                        file = new File(Contexts.engineBase(standardContext), appBase);
                    }
                    docBase = new File(file, standardContext.getDocBase());
                }
            } else {
                docBase = file;
            }
        } else {
            String path = standardContext.getPath();
            if (path == null) {
                throw new IllegalStateException("Can't find docBase");
            }
            baseName = new ContextName(path, standardContext.getWebappVersion()).getBaseName();
            docBase = new File(baseName);
        }
        if (!docBase.exists() && baseName != null) {
            if (Host.class.isInstance(container) && (file = new File(((Host)Host.class.cast(container)).getAppBaseFile(), baseName)).exists()) {
                return file;
            }
            return Contexts.oldRealWarPath(standardContext);
        }
        String name = docBase.getName();
        if (name.endsWith(".war") && (extracted = new File(docBase.getParentFile(), name.substring(0, name.length() - ".war".length()))).exists()) {
            return extracted;
        }
        return docBase;
    }

    private static File engineBase(Context standardContext) {
        String base = System.getProperty("catalina.base");
        if (base == null) {
            StandardEngine eng = (StandardEngine)standardContext.getParent().getParent();
            return eng.getCatalinaBase();
        }
        return new File(base);
    }

    @Deprecated
    private static File oldRealWarPath(Context standardContext) {
        File war;
        String doc = standardContext.getDocBase();
        if (doc == null || doc.length() == 0) {
            doc = "ROOT";
        }
        if ((war = new File(doc)).exists()) {
            return war;
        }
        StandardHost host = (StandardHost)standardContext.getParent();
        String base = host.getAppBase();
        war = new File(base, doc);
        if (war.exists()) {
            return war;
        }
        war = new File(new File(System.getProperty("catalina.home"), base), doc);
        if (war.exists()) {
            return war;
        }
        return new File(new File(System.getProperty("catalina.base"), base), doc);
    }
}

