/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.resource;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.regex.Pattern;
import javax.faces.context.FacesContext;
import org.apache.myfaces.shared.resource.ResourceLoader;
import org.apache.myfaces.shared.resource.ResourceMeta;
import org.apache.myfaces.shared.resource.ResourceMetaImpl;

public class ExternalContextResourceLoader
extends ResourceLoader {
    protected static final Pattern VERSION_CHECKER = Pattern.compile("/\\p{Digit}+(_\\p{Digit}*)*/");
    protected static final Pattern RESOURCE_VERSION_CHECKER = Pattern.compile("/\\p{Digit}+(_\\p{Digit}*)*\\..*");

    public ExternalContextResourceLoader(String prefix) {
        super(prefix);
    }

    protected Set<String> getResourcePaths(String path) {
        return FacesContext.getCurrentInstance().getExternalContext().getResourcePaths(this.getPrefix() + '/' + path);
    }

    @Override
    public String getResourceVersion(String path) {
        String resourceVersion = null;
        Set<String> resourcePaths = this.getResourcePaths(path);
        if (this.getPrefix() != null) {
            path = this.getPrefix() + '/' + path;
        }
        if (null != resourcePaths && !resourcePaths.isEmpty()) {
            for (String resourcePath : resourcePaths) {
                String version = resourcePath.substring(path.length());
                if (!RESOURCE_VERSION_CHECKER.matcher(version).matches()) continue;
                version = version.substring(1, version.lastIndexOf(46));
                if (resourceVersion == null) {
                    resourceVersion = version;
                    continue;
                }
                if (this.getVersionComparator().compare(resourceVersion, version) >= 0) continue;
                resourceVersion = version;
            }
            if (resourceVersion == null) {
                resourceVersion = "INVALID";
            }
        }
        return resourceVersion;
    }

    @Override
    public String getLibraryVersion(String path) {
        String libraryVersion = null;
        Set<String> libraryPaths = this.getResourcePaths(path);
        path = this.getPrefix() + '/' + path;
        if (null != libraryPaths && !libraryPaths.isEmpty()) {
            for (String libraryPath : libraryPaths) {
                String version = "";
                if (path.length() < libraryPath.length()) {
                    version = libraryPath.substring(path.length());
                }
                if (!VERSION_CHECKER.matcher(version).matches()) continue;
                version = version.substring(1, version.length() - 1);
                if (libraryVersion == null) {
                    libraryVersion = version;
                    continue;
                }
                if (this.getVersionComparator().compare(libraryVersion, version) >= 0) continue;
                libraryVersion = version;
            }
        }
        return libraryVersion;
    }

    public URL getResourceURL(String resourceId) {
        try {
            return FacesContext.getCurrentInstance().getExternalContext().getResource(this.getPrefix() + '/' + resourceId);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public URL getResourceURL(ResourceMeta resourceMeta) {
        return this.getResourceURL(resourceMeta.getResourceIdentifier());
    }

    @Override
    public InputStream getResourceInputStream(ResourceMeta resourceMeta) {
        return FacesContext.getCurrentInstance().getExternalContext().getResourceAsStream(this.getPrefix() + '/' + resourceMeta.getResourceIdentifier());
    }

    @Override
    public ResourceMeta createResourceMeta(String prefix, String libraryName, String libraryVersion, String resourceName, String resourceVersion) {
        return new ResourceMetaImpl(prefix, libraryName, libraryVersion, resourceName, resourceVersion);
    }

    @Override
    public boolean libraryExists(String libraryName) {
        block7: {
            if (this.getPrefix() != null && !"".equals(this.getPrefix())) {
                try {
                    URL url = FacesContext.getCurrentInstance().getExternalContext().getResource(this.getPrefix() + '/' + libraryName);
                    if (url != null) {
                        return true;
                    }
                    break block7;
                }
                catch (MalformedURLException e) {
                    return false;
                }
            }
            try {
                URL url = FacesContext.getCurrentInstance().getExternalContext().getResource(libraryName);
                if (url != null) {
                    return true;
                }
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        return false;
    }
}

