/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.jee.jpa.unit.PersistenceUnit;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.URLs;
import org.apache.openejb.util.UniqueDefaultLinkResolver;

public class PersistenceUnitLinkResolver
extends UniqueDefaultLinkResolver<PersistenceUnit> {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB, PersistenceUnitLinkResolver.class);
    private final AppModule module;

    public PersistenceUnitLinkResolver(AppModule appModule) {
        this.module = appModule;
    }

    @Override
    protected Collection<PersistenceUnit> tryToResolveForEar(Collection<PersistenceUnit> values, URI moduleUri, String link) {
        if (this.module == null || this.module.isStandaloneModule()) {
            return values;
        }
        WebModule war = this.extractWebApp(moduleUri);
        if (war != null) {
            Iterator<PersistenceUnit> it = values.iterator();
            while (it.hasNext()) {
                if (this.isIn(it.next(), war)) continue;
                it.remove();
            }
            return values;
        }
        Iterator<PersistenceUnit> it = values.iterator();
        while (it.hasNext()) {
            PersistenceUnit next = it.next();
            for (WebModule webModule : this.module.getWebModules()) {
                if (!this.isIn(next, webModule)) continue;
                it.remove();
            }
        }
        return values;
    }

    private boolean isIn(PersistenceUnit value, WebModule war) {
        Collection urls = (Collection)war.getAltDDs().get("ear-webapp-persistence-xml-jars");
        if (urls == null || urls.isEmpty()) {
            return false;
        }
        ArrayList<String> strUrls = new ArrayList<String>();
        for (URL url : urls) {
            strUrls.add(URLs.toFilePath(url));
        }
        for (PersistenceModule persistenceModule : this.module.getPersistenceModules()) {
            String rootUrl;
            Persistence persistence = persistenceModule.getPersistence();
            try {
                rootUrl = URLs.toFilePath(new URL(persistenceModule.getRootUrl()));
            }
            catch (MalformedURLException e) {
                continue;
            }
            for (PersistenceUnit unit : persistence.getPersistenceUnit()) {
                if (unit != value || !strUrls.contains(rootUrl)) continue;
                return true;
            }
        }
        return false;
    }

    private WebModule extractWebApp(URI moduleUri) {
        File moduleFile;
        if (this.module == null || this.module.getJarLocation() == null) {
            return null;
        }
        File appModuleFile = new File(this.module.getJarLocation());
        try {
            moduleFile = URLs.toFile(moduleUri.toURL());
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IllegalArgumentException iae) {
            File f = new File(appModuleFile, moduleUri.getPath());
            if (f.exists()) {
                moduleFile = f;
            }
            LOGGER.warning("Illegal uri: " + moduleUri, iae);
            return null;
        }
        for (WebModule webModule : this.module.getWebModules()) {
            if (webModule.getJarLocation() == null || !PersistenceUnitLinkResolver.isParent(new File(webModule.getJarLocation()), moduleFile, appModuleFile)) continue;
            return webModule;
        }
        return null;
    }

    private static boolean isParent(File file, File moduleFile, File appModuleFile) {
        for (File current = file; current != null; current = current.getParentFile()) {
            if (current.equals(moduleFile)) {
                return true;
            }
            if (!current.equals(appModuleFile)) continue;
            return false;
        }
        return false;
    }
}

