/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.util.FacesLogger;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.render.Renderer;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public abstract class ScriptStyleBaseRenderer
extends Renderer
implements ComponentSystemEventListener {
    private static final String COMP_KEY = ScriptStyleBaseRenderer.class.getName() + "_COMPOSITE_COMPONENT";
    protected static final Logger logger = FacesLogger.RENDERKIT.getLogger();

    @Override
    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        UIComponent component = event.getComponent();
        FacesContext context = FacesContext.getCurrentInstance();
        String target = this.verifyTarget((String)component.getAttributes().get("target"));
        if (target != null) {
            UIComponent cc = UIComponent.getCurrentCompositeComponent(context);
            if (cc != null) {
                component.getAttributes().put(COMP_KEY, cc.getClientId(context));
            }
            context.getViewRoot().addComponentResource(context, component, target);
        }
    }

    @Override
    public final void decode(FacesContext context, UIComponent component) {
    }

    @Override
    public final boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String ccID = (String)component.getAttributes().get(COMP_KEY);
        if (ccID != null) {
            component.popComponentFromEL(context);
            component.popComponentFromEL(context);
            component.pushComponentToEL(context, component);
        }
    }

    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        UIComponent curCC;
        char sep;
        UIComponent cc;
        String ccID = (String)component.getAttributes().get(COMP_KEY);
        if (null != ccID && (cc = -1 != ccID.indexOf(sep = UINamingContainer.getSeparatorChar(context)) ? context.getViewRoot().findComponent(':' + ccID) : ScriptStyleBaseRenderer.findComponentIgnoringNamingContainers(context.getViewRoot(), ccID, true)) != (curCC = UIComponent.getCurrentCompositeComponent(context))) {
            component.popComponentFromEL(context);
            component.pushComponentToEL(context, cc);
            component.pushComponentToEL(context, component);
        }
    }

    private static UIComponent findComponentIgnoringNamingContainers(UIComponent base, String id, boolean checkId) {
        if (checkId && id.equals(base.getId())) {
            return base;
        }
        UIComponent result = null;
        Iterator<UIComponent> i = base.getFacetsAndChildren();
        while (i.hasNext()) {
            UIComponent kid = i.next();
            if (checkId && id.equals(kid.getId())) {
                result = kid;
                break;
            }
            result = ScriptStyleBaseRenderer.findComponentIgnoringNamingContainers(kid, id, true);
            if (result != null) break;
            if (!id.equals(kid.getId())) continue;
            result = kid;
            break;
        }
        return result;
    }

    @Override
    public final void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        boolean renderChildren;
        Map<String, Object> attributes = component.getAttributes();
        String name = (String)attributes.get("name");
        int childCount = component.getChildCount();
        boolean bl = renderChildren = 0 < childCount;
        if (null == name) {
            if (0 == childCount) {
                if (context.isProjectStage(ProjectStage.Development)) {
                    FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_WARN, "outputScript with no library, no name, and no body content", "Is body content intended?");
                    context.addMessage(component.getClientId(context), message);
                }
                renderChildren = false;
            }
        } else if (0 < childCount) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("outputScript with \"name\" attribute and nested content.  Ignoring nested content.");
            }
            renderChildren = false;
        }
        if (renderChildren) {
            ResponseWriter writer = context.getResponseWriter();
            this.startElement(writer, component);
            super.encodeChildren(context, component);
            this.endElement(writer);
        }
    }

    protected abstract void startElement(ResponseWriter var1, UIComponent var2) throws IOException;

    protected abstract void endElement(ResponseWriter var1) throws IOException;

    protected String verifyTarget(String toVerify) {
        return toVerify;
    }
}

