/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.FacesLogger;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.PhaseId;
import javax.faces.render.ClientBehaviorRenderer;

public class AjaxBehaviorRenderer
extends ClientBehaviorRenderer {
    protected static final Logger logger = FacesLogger.RENDERKIT.getLogger();
    protected transient boolean namespaceParameters;

    public AjaxBehaviorRenderer() {
        WebConfiguration webConfig = WebConfiguration.getInstance();
        this.namespaceParameters = webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.NamespaceParameters);
    }

    @Override
    public String getScript(ClientBehaviorContext behaviorContext, ClientBehavior behavior) {
        if (!(behavior instanceof AjaxBehavior)) {
            throw new IllegalArgumentException("Instance of javax.faces.component.behavior.AjaxBehavior required: " + behavior);
        }
        if (((AjaxBehavior)behavior).isDisabled()) {
            return null;
        }
        return AjaxBehaviorRenderer.buildAjaxCommand(behaviorContext, (AjaxBehavior)behavior, this.namespaceParameters);
    }

    @Override
    public void decode(FacesContext context, UIComponent component, ClientBehavior behavior) {
        if (null == context || null == component || null == behavior) {
            throw new NullPointerException();
        }
        if (!(behavior instanceof AjaxBehavior)) {
            throw new IllegalArgumentException("Instance of javax.faces.component.behavior.AjaxBehavior required: " + behavior);
        }
        AjaxBehavior ajaxBehavior = (AjaxBehavior)behavior;
        if (ajaxBehavior.isDisabled()) {
            return;
        }
        component.queueEvent(AjaxBehaviorRenderer.createEvent(component, ajaxBehavior));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("This command resulted in form submission  AjaxBehaviorEvent queued.");
            logger.log(Level.FINE, "End decoding component {0}", component.getId());
        }
    }

    private static AjaxBehaviorEvent createEvent(UIComponent component, AjaxBehavior ajaxBehavior) {
        AjaxBehaviorEvent event = new AjaxBehaviorEvent(component, ajaxBehavior);
        PhaseId phaseId = AjaxBehaviorRenderer.isImmediate(component, ajaxBehavior) ? PhaseId.APPLY_REQUEST_VALUES : PhaseId.INVOKE_APPLICATION;
        event.setPhaseId(phaseId);
        return event;
    }

    private static boolean isImmediate(UIComponent component, AjaxBehavior ajaxBehavior) {
        boolean immediate = false;
        if (ajaxBehavior.isImmediateSet()) {
            immediate = ajaxBehavior.isImmediate();
        } else if (component instanceof EditableValueHolder) {
            immediate = ((EditableValueHolder)((Object)component)).isImmediate();
        } else if (component instanceof ActionSource) {
            immediate = ((ActionSource)((Object)component)).isImmediate();
        }
        return immediate;
    }

    private static String buildAjaxCommand(ClientBehaviorContext behaviorContext, AjaxBehavior ajaxBehavior, boolean namespaceParameters) {
        FacesContext context;
        UIViewRoot viewRoot;
        Collection<ClientBehaviorContext.Parameter> params;
        Boolean resetValues;
        String delay;
        String sourceId;
        String onerror;
        String onevent;
        Collection<String> render;
        Collection<String> execute;
        StringBuilder ajaxCommand;
        String eventName;
        UIComponent component;
        block18: {
            if (ajaxBehavior.isDisabled()) {
                return null;
            }
            component = behaviorContext.getComponent();
            eventName = behaviorContext.getEventName();
            ajaxCommand = new StringBuilder(256);
            execute = ajaxBehavior.getExecute();
            render = ajaxBehavior.getRender();
            onevent = ajaxBehavior.getOnevent();
            onerror = ajaxBehavior.getOnerror();
            sourceId = behaviorContext.getSourceId();
            delay = ajaxBehavior.getDelay();
            resetValues = null;
            if (ajaxBehavior.isResetValuesSet()) {
                resetValues = ajaxBehavior.isResetValues();
            }
            params = behaviorContext.getParameters();
            ClientBehaviorContext.Parameter foundparam = null;
            for (ClientBehaviorContext.Parameter param : params) {
                if (!param.getName().equals("incExec") || !((Boolean)param.getValue()).booleanValue()) continue;
                foundparam = param;
            }
            if (foundparam != null && !execute.contains(sourceId)) {
                execute = new LinkedList<String>(execute);
                execute.add(component.getClientId());
            }
            if (foundparam != null) {
                try {
                    params.remove(foundparam);
                }
                catch (UnsupportedOperationException uoe) {
                    if (!logger.isLoggable(Level.FINEST)) break block18;
                    logger.log(Level.FINEST, "Unsupported operation", uoe);
                }
            }
        }
        ajaxCommand.append("mojarra.ab(");
        if (sourceId == null) {
            ajaxCommand.append("this");
        } else {
            ajaxCommand.append("'");
            ajaxCommand.append(sourceId);
            ajaxCommand.append("'");
        }
        ajaxCommand.append(",event,'");
        ajaxCommand.append(eventName);
        ajaxCommand.append("',");
        AjaxBehaviorRenderer.appendIds(component, ajaxCommand, execute);
        ajaxCommand.append(",");
        AjaxBehaviorRenderer.appendIds(component, ajaxCommand, render);
        String namingContainerId = null;
        if (namespaceParameters && (viewRoot = (context = behaviorContext.getFacesContext()).getViewRoot()) instanceof NamingContainer) {
            namingContainerId = viewRoot.getContainerClientId(context);
        }
        if (namingContainerId != null || onevent != null || onerror != null || delay != null || resetValues != null || !params.isEmpty()) {
            ajaxCommand.append(",{");
            if (namingContainerId != null) {
                RenderKitUtils.appendProperty(ajaxCommand, "com.sun.faces.namingContainerId", namingContainerId, true);
            }
            if (onevent != null) {
                RenderKitUtils.appendProperty(ajaxCommand, "onevent", onevent, false);
            }
            if (onerror != null) {
                RenderKitUtils.appendProperty(ajaxCommand, "onerror", onerror, false);
            }
            if (delay != null) {
                RenderKitUtils.appendProperty(ajaxCommand, "delay", delay, true);
            }
            if (resetValues != null) {
                RenderKitUtils.appendProperty(ajaxCommand, "resetValues", resetValues, false);
            }
            if (!params.isEmpty()) {
                for (ClientBehaviorContext.Parameter param : params) {
                    RenderKitUtils.appendProperty(ajaxCommand, param.getName(), param.getValue());
                }
            }
            ajaxCommand.append("}");
        }
        ajaxCommand.append(")");
        return ajaxCommand.toString();
    }

    private static void appendIds(UIComponent component, StringBuilder builder, Collection<String> ids) {
        if (null == ids || ids.isEmpty()) {
            builder.append('0');
            return;
        }
        builder.append("'");
        boolean first = true;
        for (String id : ids) {
            if (id.trim().length() == 0) continue;
            if (!first) {
                builder.append(' ');
            } else {
                first = false;
            }
            if (id.equals("@all") || id.equals("@none") || id.equals("@form") || id.equals("@this")) {
                builder.append(id);
                continue;
            }
            builder.append(AjaxBehaviorRenderer.getResolvedId(component, id));
        }
        builder.append("'");
    }

    private static String getResolvedId(UIComponent component, String id) {
        UIComponent resolvedComponent = component.findComponent(id);
        if (resolvedComponent == null) {
            if (id.charAt(0) == UINamingContainer.getSeparatorChar(FacesContext.getCurrentInstance())) {
                return id.substring(1);
            }
            return id;
        }
        return resolvedComponent.getClientId();
    }
}

