/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.util.Collection;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.rmi.PortableRemoteObject;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.Bootstrap;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.PersistenceExceptions;
import org.apache.openjpa.persistence.PersistenceProductDerivation;
import org.apache.openjpa.persistence.PersistenceProviderImpl;
import org.apache.openjpa.util.ImplHelper;

public class OpenJPAPersistence {
    private static final Localizer _loc = Localizer.forPackage(OpenJPAPersistence.class);
    public static final String EM_KEY = "org.apache.openjpa.persistence.EntityManager";
    public static final String EMF_KEY = "org.apache.openjpa.persistence.EntityManagerFactory";

    public static OpenJPAEntityManagerFactory cast(EntityManagerFactory emf) {
        return (OpenJPAEntityManagerFactory)emf;
    }

    public static OpenJPAEntityManager cast(EntityManager em) {
        if (em instanceof OpenJPAEntityManager) {
            return (OpenJPAEntityManager)em;
        }
        return (OpenJPAEntityManager)em.getDelegate();
    }

    public static OpenJPAQuery cast(Query q) {
        return (OpenJPAQuery)q;
    }

    public static OpenJPAEntityManagerFactory getEntityManagerFactory() {
        return OpenJPAPersistence.getEntityManagerFactory(null);
    }

    public static OpenJPAEntityManagerFactory getEntityManagerFactory(Map map) {
        PersistenceProductDerivation.ConfigurationProviderImpl cp = new PersistenceProductDerivation.ConfigurationProviderImpl(map);
        try {
            return JPAFacadeHelper.toEntityManagerFactory(Bootstrap.getBrokerFactory(cp, null));
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    public static OpenJPAEntityManagerFactory createEntityManagerFactory(String name, String resource) {
        return OpenJPAPersistence.createEntityManagerFactory(name, resource, null);
    }

    public static OpenJPAEntityManagerFactory createEntityManagerFactory(String name, String resource, Map map) {
        return new PersistenceProviderImpl().createEntityManagerFactory(name, resource, map);
    }

    public static OpenJPAEntityManagerFactory createEntityManagerFactory(String jndiLocation, Context context) {
        if (jndiLocation == null) {
            throw new NullPointerException("jndiLocation == null");
        }
        try {
            if (context == null) {
                context = new InitialContext();
            }
            Object o = context.lookup(jndiLocation);
            return (OpenJPAEntityManagerFactory)PortableRemoteObject.narrow((Object)o, OpenJPAEntityManagerFactory.class);
        }
        catch (NamingException ne) {
            throw new ArgumentException(_loc.get("naming-exception", jndiLocation), new Throwable[]{ne}, null, true);
        }
    }

    public static OpenJPAEntityManager getEntityManager(Object o) {
        try {
            PersistenceCapable pc;
            if (ImplHelper.isManageable(o) && (pc = ImplHelper.toPersistenceCapable(o, null)) != null) {
                return JPAFacadeHelper.toEntityManager((Broker)pc.pcGetGenericContext());
            }
            return null;
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    public static void close(Object o) {
        try {
            ImplHelper.close(o);
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    public static boolean isManagedType(EntityManager em, Class cls) {
        try {
            return ImplHelper.isManagedType(JPAFacadeHelper.toBroker(em).getConfiguration(), cls);
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    public static OpenJPAEntityManagerFactory toEntityManagerFactory(BrokerFactory factory) {
        return JPAFacadeHelper.toEntityManagerFactory(factory);
    }

    public static BrokerFactory toBrokerFactory(EntityManagerFactory factory) {
        return JPAFacadeHelper.toBrokerFactory(factory);
    }

    public static OpenJPAEntityManager toEntityManager(Broker broker) {
        return JPAFacadeHelper.toEntityManager(broker);
    }

    public static Broker toBroker(EntityManager em) {
        return JPAFacadeHelper.toBroker(em);
    }

    public static ClassMetaData getMetaData(Object o) {
        return JPAFacadeHelper.getMetaData(o);
    }

    public static ClassMetaData getMetaData(EntityManager em, Class cls) {
        return JPAFacadeHelper.getMetaData(em, cls);
    }

    public static ClassMetaData getMetaData(EntityManagerFactory factory, Class cls) {
        return JPAFacadeHelper.getMetaData(factory, cls);
    }

    public static Object fromOpenJPAObjectId(Object oid) {
        return JPAFacadeHelper.fromOpenJPAObjectId(oid);
    }

    public static Object toOpenJPAObjectId(ClassMetaData meta, Object oid) {
        return JPAFacadeHelper.toOpenJPAObjectId(meta, oid);
    }

    public static Object[] toOpenJPAObjectIds(ClassMetaData meta, Object ... oids) {
        return JPAFacadeHelper.toOpenJPAObjectIds(meta, oids);
    }

    public static Collection toOpenJPAObjectIds(ClassMetaData meta, Collection oids) {
        return JPAFacadeHelper.toOpenJPAObjectIds(meta, oids);
    }

    public static Class fromOpenJPAObjectIdClass(Class oidClass) {
        return JPAFacadeHelper.fromOpenJPAObjectIdClass(oidClass);
    }
}

