/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.core.DefaultInstanceManager;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.NamingResourcesImpl;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.descriptor.web.ContextLocalEjb;
import org.apache.tomcat.util.descriptor.web.Injectable;
import org.apache.tomcat.util.descriptor.web.InjectionTarget;
import org.apache.tomee.catalina.InjectionFailedException;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansCreationException;

public class JavaeeInstanceManager
implements InstanceManager {
    private final WebContext webContext;
    private final StandardContext webapp;
    private final String[] skipContainerTags;
    private final String[] skipPrefixes;
    private volatile InstanceManager defaultInstanceManager;

    public JavaeeInstanceManager(StandardContext webapp, WebContext webContext) {
        this.webContext = webContext;
        this.webapp = webapp;
        this.skipContainerTags = SystemInstance.get().getProperty("tomee.tomcat.instance-manager.skip-container-tags", "org.apache.taglibs.standard.,javax.servlet.jsp.jstl.").split(" *, *");
        String[] skipCdi = SystemInstance.get().getProperty("tomee.tomcat.instance-manager.skip-cdi", "").split(" *, *");
        this.skipPrefixes = skipCdi.length == 1 && skipCdi[0].isEmpty() ? new String[]{} : skipCdi;
    }

    public ServletContext getServletContext() {
        return this.webContext == null ? null : this.webContext.getServletContext();
    }

    public Object newInstance(Class<?> clazz) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException {
        try {
            Object object;
            String name = clazz.getName();
            if ("org.apache.tomcat.websocket.server.WsHttpUpgradeHandler".equals(name) || "org.apache.tomee.myfaces.TomEEMyFacesContextListener".equals(name) || "org.apache.openejb.server.httpd.EEFilter".equals(name) || "org.apache.catalina.servlets.DefaultServlet".equals(name) || "org.apache.jasper.servlet.JspServlet".equals(name)) {
                return clazz.newInstance();
            }
            Object object2 = object = this.isSkip(name, this.skipPrefixes) ? clazz.newInstance() : this.webContext.newInstance(clazz);
            if (this.isJsp(clazz)) {
                this.initDefaultInstanceMgr();
                this.defaultInstanceManager.newInstance(object);
            }
            this.postConstruct(object, clazz);
            return object;
        }
        catch (OpenEJBException | WebBeansConfigurationException | WebBeansCreationException e) {
            throw (InstantiationException)new InstantiationException(e.getMessage()).initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDefaultInstanceMgr() {
        if (this.defaultInstanceManager == null) {
            JavaeeInstanceManager javaeeInstanceManager = this;
            synchronized (javaeeInstanceManager) {
                if (this.defaultInstanceManager == null) {
                    this.defaultInstanceManager = new DefaultInstanceManager(this.webapp.getNamingContextListener().getEnvContext(), TomcatInjections.buildInjectionMap(this.webapp.getNamingResources()), (Context)this.webapp, ParentClassLoaderFinder.Helper.get());
                }
            }
        }
    }

    private boolean isJsp(Class<?> type) {
        return type.getSuperclass().getName().equals("org.apache.jasper.runtime.HttpJspBase");
    }

    public WebContext.Instance newWeakableInstance(Class<?> clazz) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException {
        try {
            WebContext.Instance object = this.webContext.newWeakableInstance(clazz);
            this.postConstruct(object.getValue(), clazz);
            return object;
        }
        catch (OpenEJBException | WebBeansConfigurationException | WebBeansCreationException e) {
            throw (InstantiationException)new InstantiationException(e.getMessage()).initCause(e);
        }
    }

    public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        return this.newInstance(className, this.webContext.getClassLoader());
    }

    public Object newInstance(String className, ClassLoader classLoader) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        return this.newInstance(classLoader.loadClass(className));
    }

    public void newInstance(Object o) throws IllegalAccessException, InvocationTargetException, NamingException {
        String name = o.getClass().getName();
        if ("org.apache.tomee.webservices.CXFJAXRSFilter".equals(name) || "org.apache.tomcat.websocket.server.WsFilter".equals(name) || this.isSkip(name, this.skipContainerTags)) {
            return;
        }
        try {
            if (!this.isSkip(name, this.skipPrefixes)) {
                this.webContext.inject(o);
            }
            this.postConstruct(o, o.getClass());
        }
        catch (OpenEJBException e) {
            this.destroyInstance(o);
            throw new InjectionFailedException(e);
        }
    }

    private boolean isSkip(String name, String[] prefixes) {
        for (String prefix : prefixes) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyInstance(Object o) throws IllegalAccessException, InvocationTargetException {
        if (o == null) {
            return;
        }
        String name = o.getClass().getName();
        if ("org.apache.tomcat.websocket.server.WsHttpUpgradeHandler".equals(name) || "org.apache.tomee.myfaces.TomEEMyFacesContextListener".equals(name) || "org.apache.openejb.server.httpd.EEFilter".equals(name) || "org.apache.catalina.servlets.DefaultServlet".equals(name) || "org.apache.jasper.servlet.JspServlet".equals(name)) {
            return;
        }
        Object unwrapped = this.unwrap(o);
        try {
            if (this.isJsp(o.getClass())) {
                this.defaultInstanceManager.destroyInstance(o);
            }
            this.preDestroy(unwrapped, unwrapped.getClass());
        }
        finally {
            this.webContext.destroy(unwrapped);
            if (unwrapped != o) {
                this.webContext.destroy(o);
            }
        }
    }

    private Object unwrap(Object o) {
        return "org.apache.tomcat.websocket.pojo.PojoEndpointServer".equals(o.getClass().getName()) ? WebSocketTypes.unwrapWebSocketPojo(o) : o;
    }

    public void inject(Object o) {
        try {
            this.webContext.inject(o);
        }
        catch (OpenEJBException e) {
            throw new InjectionFailedException(e);
        }
    }

    public void postConstruct(Object instance, Class<?> clazz) throws IllegalAccessException, InvocationTargetException {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != Object.class) {
            this.postConstruct(instance, superClass);
        }
        Method[] methods = clazz.getDeclaredMethods();
        AccessibleObject postConstruct = null;
        for (Method method : methods) {
            if (!method.isAnnotationPresent(PostConstruct.class)) continue;
            if (postConstruct != null || method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || method.getExceptionTypes().length > 0 || !method.getReturnType().getName().equals("void")) {
                throw new IllegalArgumentException("Invalid PostConstruct annotation. @PostConstruct methods should respect the following constraints:\n- no parameter (" + (method.getParameterTypes().length == 0) + ")\n- no exception should be declared (" + (method.getExceptionTypes().length == 0) + ")\n- should return void (" + method.getReturnType().getName().equals("void") + ")\n- should not be static (" + !Modifier.isStatic(method.getModifiers()) + ")\n");
            }
            postConstruct = method;
        }
        if (postConstruct != null) {
            boolean accessibility = postConstruct.isAccessible();
            ((Method)postConstruct).setAccessible(true);
            ((Method)postConstruct).invoke(instance, new Object[0]);
            ((Method)postConstruct).setAccessible(accessibility);
        }
    }

    protected void preDestroy(Object instance, Class<?> clazz) throws IllegalAccessException, InvocationTargetException {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != Object.class) {
            this.preDestroy(instance, superClass);
        }
        Method[] methods = clazz.getDeclaredMethods();
        AccessibleObject preDestroy = null;
        for (Method method : methods) {
            if (!method.isAnnotationPresent(PreDestroy.class)) continue;
            if (method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || method.getExceptionTypes().length > 0 || !method.getReturnType().getName().equals("void")) {
                throw new IllegalArgumentException("Invalid PreDestroy annotation");
            }
            preDestroy = method;
            break;
        }
        if (preDestroy != null) {
            boolean accessibility = preDestroy.isAccessible();
            ((Method)preDestroy).setAccessible(true);
            ((Method)preDestroy).invoke(instance, new Object[0]);
            ((Method)preDestroy).setAccessible(accessibility);
        }
    }

    private static final class TomcatInjections {
        private TomcatInjections() {
        }

        private static Map<String, Map<String, String>> buildInjectionMap(NamingResourcesImpl namingResources) {
            HashMap<String, Map<String, String>> injectionMap = new HashMap<String, Map<String, String>>();
            for (ContextLocalEjb contextLocalEjb : namingResources.findLocalEjbs()) {
                TomcatInjections.addInjectionTarget((Injectable)contextLocalEjb, injectionMap);
            }
            for (ContextLocalEjb contextLocalEjb : namingResources.findEjbs()) {
                TomcatInjections.addInjectionTarget((Injectable)contextLocalEjb, injectionMap);
            }
            for (ContextLocalEjb contextLocalEjb : namingResources.findEnvironments()) {
                TomcatInjections.addInjectionTarget((Injectable)contextLocalEjb, injectionMap);
            }
            for (ContextLocalEjb contextLocalEjb : namingResources.findMessageDestinationRefs()) {
                TomcatInjections.addInjectionTarget((Injectable)contextLocalEjb, injectionMap);
            }
            for (ContextLocalEjb contextLocalEjb : namingResources.findResourceEnvRefs()) {
                TomcatInjections.addInjectionTarget((Injectable)contextLocalEjb, injectionMap);
            }
            for (ContextLocalEjb contextLocalEjb : namingResources.findResources()) {
                TomcatInjections.addInjectionTarget((Injectable)contextLocalEjb, injectionMap);
            }
            for (ContextLocalEjb contextLocalEjb : namingResources.findServices()) {
                TomcatInjections.addInjectionTarget((Injectable)contextLocalEjb, injectionMap);
            }
            return injectionMap;
        }

        private static void addInjectionTarget(Injectable resource, Map<String, Map<String, String>> injectionMap) {
            List injectionTargets = resource.getInjectionTargets();
            if (injectionTargets != null && !injectionTargets.isEmpty()) {
                String jndiName = resource.getName();
                for (InjectionTarget injectionTarget : injectionTargets) {
                    String clazz = injectionTarget.getTargetClass();
                    Map<String, String> injections = injectionMap.get(clazz);
                    if (injections == null) {
                        injections = new HashMap<String, String>();
                        injectionMap.put(clazz, injections);
                    }
                    injections.put(injectionTarget.getTargetName(), jndiName);
                }
            }
        }
    }

    private static final class WebSocketTypes {
        private static final WebSocketTypes WEB_SOCKET_TYPES = new WebSocketTypes();
        private final Method getPojo;

        private WebSocketTypes() {
            Method tmp;
            try {
                tmp = WebSocketTypes.class.getClassLoader().loadClass("org.apache.tomcat.websocket.pojo.PojoEndpointBase").getDeclaredMethod("getPojo", new Class[0]);
                tmp.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                if ("true".equals(SystemInstance.get().getProperty("tomee.websocket.skip", "false"))) {
                    tmp = null;
                }
                throw new IllegalStateException(e);
            }
            catch (ClassNotFoundException e) {
                tmp = null;
            }
            this.getPojo = tmp;
        }

        private static Object unwrapWebSocketPojo(Object o) {
            try {
                return WebSocketTypes.WEB_SOCKET_TYPES.getPojo == null ? o : WebSocketTypes.WEB_SOCKET_TYPES.getPojo.invoke(o, new Object[0]);
            }
            catch (IllegalAccessException | NullPointerException | InvocationTargetException e) {
                return o;
            }
        }
    }
}

