/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.naming.ContextBindings;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ThreadContextListener;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.catalina.OpenEJBContext;

public class TomcatThreadContextListener
implements ThreadContextListener {
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB.createChild("tomcat"), (String)"org.apache.openejb.util.resources");
    private static final String OPENEJB_CONTEXT = "OpenEJBContext";
    protected Method method;
    private Hashtable<Thread, Object> threadNameBindings;

    public TomcatThreadContextListener() {
        ContextBindings.bindContext((Object)OPENEJB_CONTEXT, (Context)new OpenEJBContext());
        try {
            this.method = ContextBindings.class.getDeclaredMethod("getThreadName", new Class[0]);
            this.method.setAccessible(true);
            Field threadNameBindingsField = ContextBindings.class.getDeclaredField("threadObjectBindings");
            threadNameBindingsField.setAccessible(true);
            this.threadNameBindings = (Hashtable)threadNameBindingsField.get(null);
        }
        catch (Exception e) {
            logger.error("Expected ContextBinding to have the method getThreadName()");
        }
    }

    public void contextEntered(ThreadContext oldContext, ThreadContext newContext) {
        try {
            Data data = new Data(this.getThreadName());
            newContext.set(Data.class, (Object)data);
        }
        catch (NamingException data) {
            // empty catch block
        }
        try {
            ContextBindings.bindThread((Object)OPENEJB_CONTEXT, null);
        }
        catch (NamingException e) {
            ContextBindings.unbindContext((Object)OPENEJB_CONTEXT, null);
            throw new IllegalArgumentException("Unable to bind OpenEJB enc");
        }
    }

    public void contextExited(ThreadContext exitedContext, ThreadContext reenteredContext) {
        ContextBindings.unbindThread((Object)OPENEJB_CONTEXT, null);
        Data data = (Data)exitedContext.get(Data.class);
        if (data != null && data.oldContextName != null) {
            try {
                ContextBindings.bindThread((Object)data.oldContextName, null);
            }
            catch (NamingException e) {
                logger.error("Exception in method contextExited", (Throwable)e);
            }
        }
    }

    private Object getThreadName() throws NamingException {
        try {
            return this.threadNameBindings.get(Thread.currentThread());
        }
        catch (Exception exception) {
            try {
                return this.method.invoke(null, new Object[0]);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null && e.getCause() instanceof NamingException) {
                    throw (NamingException)e.getCause();
                }
                logger.error("Exception in method getThreadName", (Throwable)e);
                return null;
            }
            catch (Exception e) {
                logger.error("Exception in method getThreadName", (Throwable)e);
                return null;
            }
        }
    }

    private static class Data {
        private Object oldContextName;

        public Data(Object oldContextName) {
            this.oldContextName = oldContextName;
        }
    }
}

