/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.LogManager;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.WebResourceSet;
import org.apache.catalina.loader.ParallelWebappClassLoader;
import org.apache.catalina.loader.WebappClassLoaderBase;
import org.apache.catalina.webresources.DirResourceSet;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.juli.ClassLoaderLogManager;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.classloader.ClassLoaderConfigurer;
import org.apache.openejb.classloader.CompositeClassLoaderConfigurer;
import org.apache.openejb.classloader.WebAppEnricher;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.config.QuickJarsTxtParser;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.AppFinder;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.URLs;
import org.apache.openejb.util.classloader.URLClassLoaderFirst;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.tomee.catalina.Contexts;
import org.apache.tomee.catalina.LazyStopStandardRoot;
import org.apache.tomee.catalina.TomEEClassLoaderEnricher;

public class TomEEWebappClassLoader
extends ParallelWebappClassLoader {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB, (String)TomEEWebappClassLoader.class.getName());
    private static final ThreadLocal<ClassLoaderConfigurer> INIT_CONFIGURER = new ThreadLocal();
    private static final ThreadLocal<Context> CONTEXT = new ThreadLocal();
    public static final String TOMEE_WEBAPP_FIRST = "tomee.webapp-first";
    public static final String TOMEE_EAR_DEFAULT = "tomee.ear.webapp-first";
    public static final String CLASS_EXTENSION = ".class";
    private boolean restarting;
    private boolean forceStopPhase = Boolean.parseBoolean(SystemInstance.get().getProperty("tomee.webappclassloader.force-stop-phase", "false"));
    private ClassLoaderConfigurer configurer;
    private final boolean isEar;
    private final ClassLoader containerClassLoader;
    private volatile boolean originalDelegate;
    private final int hashCode;
    private Collection<File> additionalRepos;
    private volatile boolean stopped = false;
    private final Map<String, Boolean> filterTempCache = new HashMap<String, Boolean>();
    private volatile LazyStopStandardRoot webResourceRoot;

    public TomEEWebappClassLoader() {
        this.hashCode = this.construct();
        this.setJavaseClassLoader(TomEEWebappClassLoader.getSystemClassLoader());
        this.containerClassLoader = ParentClassLoaderFinder.Helper.get();
        this.isEar = this.getInternalParent() != null && !this.getInternalParent().equals(this.containerClassLoader) && this.defaultEarBehavior();
        this.originalDelegate = this.getDelegate();
    }

    public TomEEWebappClassLoader(ClassLoader parent) {
        super(parent);
        this.hashCode = this.construct();
        this.setJavaseClassLoader(TomEEWebappClassLoader.getSystemClassLoader());
        this.containerClassLoader = ParentClassLoaderFinder.Helper.get();
        this.isEar = this.getInternalParent() != null && !this.getInternalParent().equals(this.containerClassLoader) && this.defaultEarBehavior();
        this.originalDelegate = this.getDelegate();
    }

    public ClassLoader getInternalParent() {
        return this.getParent();
    }

    private int construct() {
        this.setDelegate(TomEEWebappClassLoader.isDelegate());
        this.configurer = INIT_CONFIGURER.get();
        return super.hashCode();
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
        this.originalDelegate = delegate;
    }

    public void stop() throws LifecycleException {
        if (this.forceStopPhase || this.restarting) {
            this.internalStop();
        }
    }

    public Collection<File> getAdditionalRepos() {
        this.initAdditionalRepos();
        return this.additionalRepos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if ("org.apache.openejb.hibernate.OpenEJBJtaPlatform".equals(name) || "org.apache.openejb.jpa.integration.hibernate.PrefixNamingStrategy".equals(name) || "org.apache.openejb.jpa.integration.eclipselink.PrefixSessionCustomizer".equals(name) || "org.apache.openejb.jpa.integration.eclipselink.OpenEJBServerPlatform".equals(name) || "org.apache.openejb.jpa.integration.eclipselink.OpenEJBServerPlatform$OpenEJBJTATransactionController".equals(name) || "org.apache.openejb.eclipselink.JTATransactionController".equals(name) || "org.apache.tomee.mojarra.TomEEInjectionProvider".equals(name)) {
            TomEEWebappClassLoader tomEEWebappClassLoader = this;
            synchronized (tomEEWebappClassLoader) {
                Class clazz;
                ClassLoader old = this.getJavaseClassLoader();
                this.setJavaseClassLoader(NoClassClassLoader.INSTANCE);
                this.delegate = false;
                try {
                    clazz = super.loadClass(name, resolve);
                }
                catch (Throwable throwable) {
                    this.setJavaseClassLoader(old);
                    this.setDelegate(this.originalDelegate);
                    throw throwable;
                }
                this.setJavaseClassLoader(old);
                this.setDelegate(this.originalDelegate);
                return clazz;
            }
        }
        if (URLClassLoaderFirst.shouldDelegateToTheContainer((ClassLoader)((Object)this), (String)name)) {
            try {
                return OpenEJB.class.getClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                TomEEWebappClassLoader old = this;
                synchronized (old) {
                    return super.loadClass(name, resolve);
                }
            }
            catch (NoClassDefFoundError ncdfe) {
                TomEEWebappClassLoader old = this;
                synchronized (old) {
                    return super.loadClass(name, resolve);
                }
            }
        }
        if (name.startsWith("javax.faces.") || name.startsWith("org.apache.webbeans.jsf")) {
            TomEEWebappClassLoader tomEEWebappClassLoader = this;
            synchronized (tomEEWebappClassLoader) {
                Class old;
                this.delegate = false;
                try {
                    old = super.loadClass(name, resolve);
                    this.setDelegate(this.originalDelegate);
                }
                catch (Throwable throwable) {
                    this.setDelegate(this.originalDelegate);
                    throw throwable;
                }
                return old;
            }
        }
        TomEEWebappClassLoader tomEEWebappClassLoader = this;
        synchronized (tomEEWebappClassLoader) {
            if (this.isEar) {
                boolean filter = this.filter(name, true);
                this.filterTempCache.put(name, filter);
                if (!filter) {
                    if (URLClassLoaderFirst.class.isInstance(this.getInternalParent())) {
                        URLClassLoaderFirst urlClassLoaderFirst = (URLClassLoaderFirst)URLClassLoaderFirst.class.cast(this.getInternalParent());
                        Class c = urlClassLoaderFirst.findAlreadyLoadedClass(name);
                        if (c != null) {
                            return c;
                        }
                        c = urlClassLoaderFirst.loadInternal(name, resolve);
                        if (c != null) {
                            return c;
                        }
                    }
                    return this.loadWithDelegate(this.getResource(name.replace('.', '/') + CLASS_EXTENSION) == null, resolve, name);
                }
            }
            return super.loadClass(name, resolve);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadWithDelegate(boolean delegate, boolean resolve, String name) throws ClassNotFoundException {
        this.setDelegate(delegate);
        try {
            Class clazz = super.loadClass(name, resolve);
            return clazz;
        }
        finally {
            this.filterTempCache.remove(name);
            this.setDelegate(this.originalDelegate);
        }
    }

    public void setResources(WebResourceRoot resources) {
        List jars;
        this.resources = resources;
        if (StandardRoot.class.isInstance(resources) && (jars = (List)Reflections.get((Object)resources, (String)"jarResources")) != null && !jars.isEmpty()) {
            Iterator jarIt = jars.iterator();
            while (jarIt.hasNext()) {
                WebResourceSet set = (WebResourceSet)jarIt.next();
                if (set.getBaseUrl() == null) continue;
                File file = URLs.toFile((URL)set.getBaseUrl());
                try {
                    if (!file.exists() || TomEEClassLoaderEnricher.validateJarFile(file) && this.jarIsAccepted(file)) continue;
                    LOGGER.warning("Removing " + file.getAbsolutePath() + " since it is offending");
                    jarIt.remove();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean filter(String inName, boolean isClassName) {
        String name;
        String string = name = inName == null || isClassName ? inName : inName.replace('/', '.').replace(CLASS_EXTENSION, "");
        if ("org.apache.tomee.mojarra.TomEEInjectionProvider".equals(name)) {
            return false;
        }
        if (this.isEar) {
            TomEEWebappClassLoader tomEEWebappClassLoader = this;
            synchronized (tomEEWebappClassLoader) {
                Boolean cache = this.filterTempCache.get(name);
                if (cache != null) {
                    return cache;
                }
            }
        }
        return URLClassLoaderFirst.shouldSkip((String)name);
    }

    public void internalDestroy() {
        try {
            if (!this.stopped) {
                try {
                    this.internalStop();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
            super.destroy();
        }
        finally {
            this.cleanUpClassLoader();
        }
    }

    public void internalStop() throws LifecycleException {
        if (this.stopped) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        thread.setContextClassLoader((ClassLoader)((Object)this));
        try {
            super.stop();
            if (this.webResourceRoot != null) {
                this.webResourceRoot.internalStop();
                this.webResourceRoot = null;
            }
            this.stopped = true;
        }
        finally {
            thread.setContextClassLoader(loader);
            if (!this.forceStopPhase) {
                this.cleanUpClassLoader();
            }
        }
    }

    public void restarting() {
        this.restarting = true;
    }

    public void restarted() {
        this.restarting = false;
    }

    public boolean isRestarting() {
        return this.restarting;
    }

    public boolean isForceStopPhase() {
        return this.forceStopPhase;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public synchronized void initAdditionalRepos() {
        if (this.additionalRepos != null) {
            return;
        }
        if (CONTEXT.get() != null) {
            this.additionalRepos = new LinkedList<File>();
            String contextPath = CONTEXT.get().getServletContext().getContextPath();
            String name = contextPath.isEmpty() ? "ROOT" : contextPath.substring(1);
            String externalRepositories = SystemInstance.get().getProperty("tomee." + name + ".externalRepositories");
            if (externalRepositories != null) {
                for (String additional : externalRepositories.split(",")) {
                    String trim = additional.trim();
                    if (trim.isEmpty()) continue;
                    File file = new File(trim);
                    this.additionalRepos.add(file);
                }
            }
        }
    }

    public void start() throws LifecycleException {
        super.start();
        this.initAdditionalRepos();
        if (this.additionalRepos != null && !this.additionalRepos.isEmpty()) {
            for (File file : this.additionalRepos) {
                PremptiveDirResourceSet webResourceSet = new PremptiveDirResourceSet(this.resources, "/", file.getAbsolutePath(), "/");
                this.resources.addPreResources((WebResourceSet)webResourceSet);
            }
            this.resources.setCachingAllowed(false);
        }
        if (this.configurer != null) {
            URL[] enrichment;
            for (URL url : enrichment = this.configurer.additionalURLs()) {
                super.addURL(url);
            }
        }
        for (URL url : ((WebAppEnricher)SystemInstance.get().getComponent(WebAppEnricher.class)).enrichment((ClassLoader)((Object)this))) {
            super.addURL(url);
        }
        File war = Contexts.warPath(CONTEXT.get());
        File file = new File(war, "WEB-INF/jars.txt");
        ClassLoaderConfigurer configurerTxt = QuickJarsTxtParser.parse((File)file);
        if (configurerTxt != null) {
            this.configurer = new CompositeClassLoaderConfigurer(new ClassLoaderConfigurer[]{this.configurer, configurerTxt});
        }
        this.stopped = false;
    }

    public void addURL(URL url) {
        if (this.configurer == null || this.configurer.accept(url)) {
            super.addURL(url);
        }
    }

    private boolean jarIsAccepted(File file) {
        if (this.configurer == null) {
            return true;
        }
        try {
            if (!this.configurer.accept(file.toURI().toURL())) {
                LOGGER.warning("jar '" + file.getAbsolutePath() + "' is excluded: " + file.getName() + ". It will be ignored.");
                return false;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return true;
    }

    protected boolean defaultEarBehavior() {
        return !SystemInstance.get().getOptions().get(TOMEE_EAR_DEFAULT, false);
    }

    private static boolean isDelegate() {
        return !SystemInstance.get().getOptions().get(TOMEE_WEBAPP_FIRST, true);
    }

    public InputStream getResourceAsStream(String name) {
        if (!this.getState().isAvailable()) {
            ClassLoader loader = ParentClassLoaderFinder.Helper.get();
            return loader == null ? null : loader.getResourceAsStream(name);
        }
        try {
            return super.getResourceAsStream(name);
        }
        catch (NullPointerException npe) {
            URL url = super.getResource(name);
            if (url != null) {
                try {
                    return url.openStream();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        if (!this.getState().isAvailable()) {
            ClassLoader loader = ParentClassLoaderFinder.Helper.get();
            return loader == null ? Collections.emptyEnumeration() : loader.getResources(name);
        }
        if ("META-INF/services/javax.servlet.ServletContainerInitializer".equals(name)) {
            ArrayList list = new ArrayList(Collections.list(super.getResources(name)));
            Iterator it = list.iterator();
            while (it.hasNext()) {
                URL next = (URL)it.next();
                File file = Files.toFile((URL)next);
                if (file.isFile() || !NewLoaderLogic.skip((URL)next)) continue;
                it.remove();
            }
            return Collections.enumeration(list);
        }
        if ("META-INF/services/javax.websocket.ContainerProvider".equals(name)) {
            ArrayList list = new ArrayList(Collections.list(super.getResources(name)));
            Iterator it = list.iterator();
            while (it.hasNext()) {
                URL next = (URL)it.next();
                File file = Files.toFile((URL)next);
                if (file.isFile() || !NewLoaderLogic.skip((URL)next)) continue;
                it.remove();
            }
            return Collections.enumeration(list);
        }
        if ("META-INF/faces-config.xml".equals(name)) {
            try {
                if (AppFinder.findAppContextOrWeb((ClassLoader)Thread.currentThread().getContextClassLoader(), (AppFinder.Transformer)AppFinder.WebBeansContextTransformer.INSTANCE) == null && Boolean.parseBoolean(SystemInstance.get().getProperty("tomee.jsf.ignore-owb", "true"))) {
                    HashSet list = new HashSet(Collections.list(super.getResources(name)));
                    Iterator it = list.iterator();
                    while (it.hasNext()) {
                        String fileName = Files.toFile((URL)((URL)it.next())).getName();
                        if (!fileName.startsWith("openwebbeans-") || !fileName.endsWith(".jar")) continue;
                        it.remove();
                    }
                    return Collections.enumeration(list);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return URLClassLoaderFirst.filterResources((String)name, (Enumeration)super.getResources(name));
    }

    public boolean equals(Object other) {
        return other != null && ClassLoader.class.isInstance(other) && this.hashCode() == other.hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public TomEEWebappClassLoader copyWithoutTransformers() {
        TomEEWebappClassLoader result = new TomEEWebappClassLoader(this.getInternalParent());
        result.additionalRepos = this.additionalRepos;
        result.configurer = this.configurer;
        super.copyStateWithoutTransformers((WebappClassLoaderBase)result);
        try {
            result.start();
        }
        catch (LifecycleException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public void destroy() {
        if (this.forceStopPhase) {
            this.internalDestroy();
        }
    }

    private void cleanUpClassLoader() {
        LogManager lm = LogManager.getLogManager();
        if (ClassLoaderLogManager.class.isInstance(lm)) {
            ((Map)Map.class.cast(Reflections.get((Object)lm, (String)"classLoaderLoggers"))).remove((Object)this);
        }
    }

    public static void initContext(ClassLoaderConfigurer configurer) {
        INIT_CONFIGURER.set(configurer);
    }

    public static void initContext(Context ctx) {
        CONTEXT.set(ctx);
    }

    public static void cleanContext() {
        INIT_CONFIGURER.remove();
        CONTEXT.remove();
    }

    public void setWebResourceRoot(LazyStopStandardRoot webResourceRoot) {
        this.webResourceRoot = webResourceRoot;
    }

    static {
        boolean result = ClassLoader.registerAsParallelCapable();
        if (!result) {
            LOGGER.warning("Can't register // tomee webapp classloader");
        }
    }

    private static final class PremptiveDirResourceSet
    extends DirResourceSet {
        private static final String WEB_INF_CLASSES = "/WEB-INF/classes";

        public PremptiveDirResourceSet(WebResourceRoot resources, String s, String absolutePath, String s1) {
            super(resources, s, absolutePath, s1);
        }

        public WebResource getResource(String path) {
            return super.getResource(PremptiveDirResourceSet.computePath(path));
        }

        public String[] list(String path) {
            return super.list(PremptiveDirResourceSet.computePath(path));
        }

        private static String computePath(String path) {
            if (WEB_INF_CLASSES.equals(path)) {
                return "/";
            }
            return path.startsWith(WEB_INF_CLASSES) ? path.substring(WEB_INF_CLASSES.length()) : path;
        }
    }

    private static class NoClassClassLoader
    extends ClassLoader {
        private static final NoClassClassLoader INSTANCE = new NoClassClassLoader();

        private NoClassClassLoader() {
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException();
        }
    }
}

