/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.viewstate;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.application.StateCache;
import org.apache.myfaces.application.viewstate.CsrfSessionTokenFactory;
import org.apache.myfaces.application.viewstate.RandomCsrfSessionTokenFactory;
import org.apache.myfaces.application.viewstate.SecureRandomCsrfSessionTokenFactory;
import org.apache.myfaces.shared.util.WebConfigParamUtils;

class ClientSideStateCacheImpl
extends StateCache<Object, Object> {
    public static final String INIT_PARAM_CLIENT_VIEW_STATE_TIMEOUT = "org.apache.myfaces.CLIENT_VIEW_STATE_TIMEOUT";
    public static final Long INIT_PARAM_CLIENT_VIEW_STATE_TIMEOUT_DEFAULT = 0L;
    private static final int STATE_PARAM = 0;
    private static final int VIEWID_PARAM = 1;
    private static final int TIMESTAMP_PARAM = 2;
    private static final Object[] EMPTY_STATES = new Object[]{null, null};
    private Long _clientViewStateTimeout;
    private CsrfSessionTokenFactory csrfSessionTokenFactory;

    public ClientSideStateCacheImpl() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String csrfRandomMode = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN", "random");
        this.csrfSessionTokenFactory = "secureRandom".equals(csrfRandomMode) ? new SecureRandomCsrfSessionTokenFactory(facesContext) : new RandomCsrfSessionTokenFactory(facesContext);
    }

    @Override
    public Object saveSerializedView(FacesContext facesContext, Object serializedView) {
        return this.encodeSerializedState(facesContext, serializedView);
    }

    @Override
    public Object restoreSerializedView(FacesContext facesContext, String viewId, Object viewState) {
        Object[] state = (Object[])viewState;
        long clientViewStateTimeout = this.getClientViewStateTimeout(facesContext.getExternalContext());
        if (clientViewStateTimeout > 0L) {
            Long timeStamp = (Long)state[2];
            if (timeStamp == null) {
                return null;
            }
            long passedTime = (System.currentTimeMillis() - timeStamp) / 60000L;
            if (passedTime > clientViewStateTimeout) {
                return null;
            }
        }
        String restoredViewId = (String)state[1];
        if (viewId != null && !viewId.equals(restoredViewId)) {
            return null;
        }
        if (state[0] == null) {
            return EMPTY_STATES;
        }
        Object serializedView = state[0];
        if (serializedView instanceof Object[] && ((Object[])serializedView).length == 2 && ((Object[])serializedView)[0] == null && ((Object[])serializedView)[1] == null) {
            return null;
        }
        return state[0];
    }

    @Override
    public Object encodeSerializedState(FacesContext facesContext, Object serializedView) {
        Object[] state = null;
        if (this.getClientViewStateTimeout(facesContext.getExternalContext()) > 0L) {
            state = new Object[3];
            state[2] = System.currentTimeMillis();
        } else {
            state = new Object[]{serializedView == null ? EMPTY_STATES : (serializedView instanceof Object[] && ((Object[])serializedView).length == 2 && ((Object[])serializedView)[0] == null && ((Object[])serializedView)[1] == null ? null : serializedView), facesContext.getViewRoot().getViewId()};
        }
        return state;
    }

    @Override
    public boolean isWriteStateAfterRenderViewRequired(FacesContext facesContext) {
        return true;
    }

    protected Long getClientViewStateTimeout(ExternalContext context) {
        if (this._clientViewStateTimeout == null) {
            this._clientViewStateTimeout = WebConfigParamUtils.getLongInitParameter(context, INIT_PARAM_CLIENT_VIEW_STATE_TIMEOUT, (long)INIT_PARAM_CLIENT_VIEW_STATE_TIMEOUT_DEFAULT);
            if (this._clientViewStateTimeout < 0L) {
                this._clientViewStateTimeout = 0L;
            }
        }
        return this._clientViewStateTimeout;
    }

    @Override
    public String createCryptographicallyStrongTokenFromSession(FacesContext context) {
        return this.csrfSessionTokenFactory.createCryptographicallyStrongTokenFromSession(context);
    }
}

