/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.retry;

import java.time.Duration;
import java.util.Collection;
import net.jodah.failsafe.RetryPolicy;
import org.apache.safeguard.api.retry.RetryDefinition;

public class FailsafeRetryDefinition
implements RetryDefinition {
    private final RetryPolicy retryPolicy;
    private final Collection<Class<? extends Throwable>> retryExceptions;
    private final Collection<Class<? extends Throwable>> abortExceptions;

    FailsafeRetryDefinition(RetryPolicy retryPolicy, Collection<Class<? extends Throwable>> retryExceptions, Collection<Class<? extends Throwable>> abortExceptions) {
        this.retryPolicy = retryPolicy;
        this.retryExceptions = retryExceptions;
        this.abortExceptions = abortExceptions;
    }

    public int getMaxRetries() {
        return this.retryPolicy.getMaxRetries();
    }

    public Duration getDelay() {
        net.jodah.failsafe.util.Duration delay = this.retryPolicy.getDelay();
        return Duration.ofMillis(delay.toMillis());
    }

    public Duration getMaxDuration() {
        net.jodah.failsafe.util.Duration maxDuration = this.retryPolicy.getMaxDuration();
        return Duration.ofMillis(maxDuration.toMillis());
    }

    public Duration getJitter() {
        net.jodah.failsafe.util.Duration jitter = this.retryPolicy.getJitter();
        return Duration.ofMillis(jitter.toMillis());
    }

    public Collection<Class<? extends Throwable>> getRetryExceptions() {
        return this.retryExceptions;
    }

    public Collection<Class<? extends Throwable>> getAbortExceptions() {
        return this.abortExceptions;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }
}

