/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.retry;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.RetryPolicy;
import org.apache.safeguard.api.retry.RetryBuilder;
import org.apache.safeguard.impl.retry.FailsafeRetryDefinition;
import org.apache.safeguard.impl.retry.FailsafeRetryManager;

public class FailsafeRetryBuilder
implements RetryBuilder {
    private final List<Class<? extends Throwable>> retryOn;
    private final List<Class<? extends Throwable>> abortOn;
    private final RetryPolicy retryPolicy;
    private final String name;
    private final FailsafeRetryManager failsafeRetryManager;

    FailsafeRetryBuilder(String name, FailsafeRetryManager failsafeRetryManager) {
        this.name = name;
        this.failsafeRetryManager = failsafeRetryManager;
        this.retryOn = new ArrayList<Class<? extends Throwable>>();
        this.abortOn = new ArrayList<Class<? extends Throwable>>();
        this.retryPolicy = new RetryPolicy();
    }

    public FailsafeRetryBuilder withMaxRetries(int maxRetries) {
        this.retryPolicy.withMaxRetries(maxRetries);
        return this;
    }

    public FailsafeRetryBuilder withDelay(Duration delay) {
        this.retryPolicy.withDelay(delay.toNanos(), TimeUnit.NANOSECONDS);
        return this;
    }

    public FailsafeRetryBuilder withMaxDuration(Duration maxDuration) {
        this.retryPolicy.withMaxDuration(maxDuration.toNanos(), TimeUnit.NANOSECONDS);
        return this;
    }

    public FailsafeRetryBuilder withJitter(Duration jitter) {
        this.retryPolicy.withJitter(jitter.toNanos(), TimeUnit.NANOSECONDS);
        return this;
    }

    public FailsafeRetryBuilder withAbortOn(Class<? extends Throwable> ... abortOn) {
        this.abortOn.addAll(Arrays.asList(abortOn));
        return this;
    }

    public FailsafeRetryBuilder withRetryOn(Class<? extends Throwable> ... retryOn) {
        this.retryOn.addAll(Arrays.asList(retryOn));
        return this;
    }

    public FailsafeRetryDefinition build() {
        if (!this.abortOn.isEmpty()) {
            this.retryPolicy.abortOn(this.abortOn);
        }
        if (!this.retryOn.isEmpty()) {
            this.retryPolicy.retryOn(this.retryOn);
        }
        FailsafeRetryDefinition definition = new FailsafeRetryDefinition(this.retryPolicy, this.retryOn, this.abortOn);
        this.failsafeRetryManager.register(this.name, definition);
        return definition;
    }
}

