/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.fallback;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import javax.enterprise.inject.spi.CDI;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;

public class FallbackRunner {
    private final Class<? extends FallbackHandler<?>> handlerClass;
    private final String method;

    public FallbackRunner(Class<? extends FallbackHandler<?>> handlerClass, String method) {
        this.handlerClass = handlerClass;
        this.method = method;
    }

    public Object executeFallback(InvocationContext invocationContext) {
        if (this.method != null) {
            try {
                Method method = this.getMethod(invocationContext.getTarget().getClass());
                Parameter[] parameters = method.getParameters();
                if (parameters.length == 0) {
                    return method.invoke(invocationContext.getTarget(), new Object[0]);
                }
                return method.invoke(invocationContext.getTarget(), invocationContext.getParameters());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        SafeguardExecutionContext executionContext = new SafeguardExecutionContext(invocationContext.getMethod(), invocationContext.getParameters());
        CDI cdi = CDI.current();
        FallbackHandler fallbackHandler = null;
        try {
            fallbackHandler = (FallbackHandler)cdi.select(this.handlerClass, new Annotation[0]).get();
        }
        catch (Exception e) {
            try {
                fallbackHandler = this.handlerClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e1) {
                throw new IllegalArgumentException(e);
            }
        }
        return fallbackHandler.handle((ExecutionContext)executionContext);
    }

    private Method getMethod(Class<?> aClass) {
        for (Method method : aClass.getMethods()) {
            if (!method.getName().equals(this.method)) continue;
            return method;
        }
        return null;
    }

    private static class SafeguardExecutionContext
    implements ExecutionContext {
        private final Method method;
        private final Object[] parameters;

        private SafeguardExecutionContext(Method method, Object[] parameters) {
            this.method = method;
            this.parameters = parameters;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object[] getParameters() {
            return this.parameters;
        }
    }
}

