/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.executionPlans;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.safeguard.api.circuitbreaker.CircuitBreakerState;
import org.apache.safeguard.impl.circuitbreaker.FailsafeCircuitBreaker;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;

class TimeoutWrappedCallable<T>
implements Callable<T> {
    private final Callable<T> delegate;
    private final ScheduledExecutorService executorService;
    private final Duration timeout;
    private final FailsafeCircuitBreaker failsafeCircuitBreaker;
    private boolean timedout = false;

    TimeoutWrappedCallable(Callable<T> delegate, ScheduledExecutorService executorService, Duration timeout, FailsafeCircuitBreaker failsafeCircuitBreaker) {
        this.delegate = delegate;
        this.executorService = executorService;
        this.timeout = timeout;
        this.failsafeCircuitBreaker = failsafeCircuitBreaker;
    }

    @Override
    public T call() throws Exception {
        T result;
        boolean circuitBreakerOpen;
        boolean bl = circuitBreakerOpen = this.failsafeCircuitBreaker != null && this.failsafeCircuitBreaker.getState() == CircuitBreakerState.OPEN;
        if (circuitBreakerOpen) {
            throw new CircuitBreakerOpenException();
        }
        ScheduledFuture<?> scheduledFuture = this.executorService.schedule(new TimerRunnable(Thread.currentThread(), this), this.timeout.toNanos(), TimeUnit.NANOSECONDS);
        try {
            result = this.delegate.call();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            scheduledFuture.cancel(true);
        }
        if (this.timedout) {
            throw new TimeoutException("Execution timed out after " + this.timeout);
        }
        return result;
    }

    private class TimerRunnable
    implements Runnable {
        private final Thread targetThread;
        private final TimeoutWrappedCallable task;
        private boolean doInterrupt = true;

        private TimerRunnable(Thread targetThread, TimeoutWrappedCallable task) {
            this.targetThread = targetThread;
            this.task = task;
        }

        @Override
        public void run() {
            if (this.doInterrupt) {
                this.task.timedout = true;
                this.targetThread.interrupt();
            }
        }
    }
}

