/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.executionPlans;

import java.util.concurrent.Callable;
import javax.interceptor.InvocationContext;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.SyncFailsafe;
import org.apache.safeguard.impl.circuitbreaker.FailsafeCircuitBreaker;
import org.apache.safeguard.impl.executionPlans.ExecutionPlan;
import org.apache.safeguard.impl.fallback.FallbackRunner;
import org.apache.safeguard.impl.retry.FailsafeRetryDefinition;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;

public class SyncFailsafeExecutionPlan
implements ExecutionPlan {
    protected final FailsafeRetryDefinition retryDefinition;
    protected final FailsafeCircuitBreaker failsafeCircuitBreaker;
    private final FallbackRunner fallback;

    SyncFailsafeExecutionPlan(FailsafeRetryDefinition retryDefinition, FailsafeCircuitBreaker failsafeCircuitBreaker, FallbackRunner fallback) {
        this.retryDefinition = retryDefinition;
        this.failsafeCircuitBreaker = failsafeCircuitBreaker;
        this.fallback = fallback;
        this.validateConfig();
    }

    private void validateConfig() {
        if (this.retryDefinition == null && this.failsafeCircuitBreaker == null) {
            throw new IllegalStateException("For non-async invocations, must have at least one of RetryDefintion or CircuitBreaker defined");
        }
    }

    @Override
    public <T> T execute(Callable<T> callable, InvocationContext invocationContext) {
        SyncFailsafe<?> syncFailsafe = this.getSyncFailsafe(invocationContext);
        try {
            return (T)syncFailsafe.get(callable);
        }
        catch (net.jodah.failsafe.CircuitBreakerOpenException e) {
            throw new CircuitBreakerOpenException((Throwable)e);
        }
    }

    SyncFailsafe<?> getSyncFailsafe(InvocationContext invocationContext) {
        Callable<Object> callable = () -> this.fallback.executeFallback(invocationContext);
        SyncFailsafe syncFailsafe = this.retryDefinition == null ? Failsafe.with((CircuitBreaker)this.failsafeCircuitBreaker.getDefinition().getCircuitBreaker()) : (this.failsafeCircuitBreaker == null ? Failsafe.with((RetryPolicy)this.retryDefinition.getRetryPolicy()) : (SyncFailsafe)Failsafe.with((RetryPolicy)this.retryDefinition.getRetryPolicy()).with(this.failsafeCircuitBreaker.getDefinition().getCircuitBreaker()));
        if (this.fallback != null) {
            syncFailsafe = (SyncFailsafe)syncFailsafe.withFallback(callable);
        }
        return syncFailsafe;
    }
}

