/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.executionPlans;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import org.apache.safeguard.api.bulkhead.BulkheadBuilder;
import org.apache.safeguard.api.bulkhead.BulkheadManager;
import org.apache.safeguard.api.config.ConfigFacade;
import org.apache.safeguard.impl.circuitbreaker.FailsafeCircuitBreaker;
import org.apache.safeguard.impl.circuitbreaker.FailsafeCircuitBreakerBuilder;
import org.apache.safeguard.impl.circuitbreaker.FailsafeCircuitBreakerDefinition;
import org.apache.safeguard.impl.circuitbreaker.FailsafeCircuitBreakerManager;
import org.apache.safeguard.impl.config.MicroprofileAnnotationMapper;
import org.apache.safeguard.impl.executionPlans.AsyncFailsafeExecutionPlan;
import org.apache.safeguard.impl.executionPlans.AsyncOnlyExecutionPlan;
import org.apache.safeguard.impl.executionPlans.AsyncTimeoutExecutionPlan;
import org.apache.safeguard.impl.executionPlans.BasicExecutionPlan;
import org.apache.safeguard.impl.executionPlans.BulkheadExecutionPlan;
import org.apache.safeguard.impl.executionPlans.ExecutionPlan;
import org.apache.safeguard.impl.executionPlans.FallbackOnlyExecutionPlan;
import org.apache.safeguard.impl.executionPlans.SyncFailsafeExecutionPlan;
import org.apache.safeguard.impl.fallback.FallbackRunner;
import org.apache.safeguard.impl.retry.FailsafeRetryBuilder;
import org.apache.safeguard.impl.retry.FailsafeRetryDefinition;
import org.apache.safeguard.impl.retry.FailsafeRetryManager;
import org.apache.safeguard.impl.util.AnnotationUtil;
import org.apache.safeguard.impl.util.NamingUtil;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

public class ExecutionPlanFactory {
    private final FailsafeCircuitBreakerManager circuitBreakerManager;
    private final FailsafeRetryManager retryManager;
    private final BulkheadManager bulkheadManager;
    private final MicroprofileAnnotationMapper microprofileAnnotationMapper;
    private ConcurrentMap<String, ExecutionPlan> executionPlanMap = new ConcurrentHashMap<String, ExecutionPlan>();
    private final boolean enableAllMicroProfileFeatures;

    public ExecutionPlanFactory(FailsafeCircuitBreakerManager circuitBreakerManager, FailsafeRetryManager retryManager, BulkheadManager bulkheadManager, MicroprofileAnnotationMapper microprofileAnnotationMapper) {
        this.circuitBreakerManager = circuitBreakerManager;
        this.retryManager = retryManager;
        this.bulkheadManager = bulkheadManager;
        this.microprofileAnnotationMapper = microprofileAnnotationMapper;
        this.enableAllMicroProfileFeatures = this.enableNonFallbacksForMicroProfile();
    }

    public ExecutionPlan locateExecutionPlan(String name, Duration timeout, boolean async) {
        return this.executionPlanMap.computeIfAbsent(name, key -> {
            FailsafeCircuitBreaker circuitBreaker = this.circuitBreakerManager.getCircuitBreaker((String)key);
            FailsafeRetryDefinition retryDefinition = this.retryManager.getRetryDefinition((String)key);
            if (circuitBreaker == null && retryDefinition == null) {
                return null;
            }
            return new SyncFailsafeExecutionPlan(retryDefinition, circuitBreaker, null);
        });
    }

    public ExecutionPlan locateExecutionPlan(Method method) {
        String name = NamingUtil.createName(method);
        return this.executionPlanMap.computeIfAbsent(name, key -> {
            org.apache.safeguard.api.bulkhead.Bulkhead bulkhead;
            FailsafeRetryDefinition retryDefinition;
            FailsafeCircuitBreaker circuitBreaker = this.circuitBreakerManager.getCircuitBreaker(name);
            if (circuitBreaker == null) {
                circuitBreaker = this.createCBDefinition(name, method);
            }
            if ((retryDefinition = this.retryManager.getRetryDefinition(name)) == null) {
                retryDefinition = this.createDefinition(name, method);
            }
            if ((bulkhead = this.bulkheadManager.getBulkhead(name)) == null) {
                bulkhead = this.createBulkhead(name, method);
            }
            boolean isAsync = this.isAsync(method);
            Duration timeout = this.readTimeout(method);
            FallbackRunner fallbackRunner = this.createFallback(method);
            if (this.enableAllMicroProfileFeatures) {
                BulkheadExecutionPlan parent = new BulkheadExecutionPlan(bulkhead);
                if (circuitBreaker == null && retryDefinition == null && isAsync) {
                    if (timeout == null) {
                        parent.setChild(new AsyncOnlyExecutionPlan(null));
                    } else {
                        parent.setChild(new AsyncTimeoutExecutionPlan(timeout, Executors.newFixedThreadPool(5)));
                    }
                } else if (circuitBreaker == null && retryDefinition == null && timeout != null) {
                    parent.setChild(new AsyncTimeoutExecutionPlan(timeout, Executors.newFixedThreadPool(5)));
                } else if (isAsync || timeout != null) {
                    parent.setChild(new AsyncFailsafeExecutionPlan(retryDefinition, circuitBreaker, fallbackRunner, Executors.newScheduledThreadPool(5), timeout));
                } else if (circuitBreaker == null && retryDefinition == null && fallbackRunner == null) {
                    parent.setChild(new BasicExecutionPlan());
                } else if (circuitBreaker == null && retryDefinition == null) {
                    parent.setChild(new FallbackOnlyExecutionPlan(fallbackRunner));
                } else {
                    parent.setChild(new SyncFailsafeExecutionPlan(retryDefinition, circuitBreaker, fallbackRunner));
                }
                return parent;
            }
            if (fallbackRunner == null) {
                return new BasicExecutionPlan();
            }
            return new FallbackOnlyExecutionPlan(fallbackRunner);
        });
    }

    private boolean enableNonFallbacksForMicroProfile() {
        return ConfigFacade.getInstance().getBoolean("MP_Fault_Tolerance_NonFallback_Enabled", true);
    }

    private FailsafeRetryDefinition createDefinition(String name, Method method) {
        Retry retry = AnnotationUtil.getAnnotation(method, Retry.class);
        if (retry == null) {
            return null;
        }
        FailsafeRetryBuilder retryBuilder = this.retryManager.newRetryDefinition(name);
        return this.microprofileAnnotationMapper.mapRetry(method, retry, retryBuilder);
    }

    private FailsafeCircuitBreaker createCBDefinition(String name, Method method) {
        CircuitBreaker circuitBreaker = AnnotationUtil.getAnnotation(method, CircuitBreaker.class);
        if (circuitBreaker == null) {
            return null;
        }
        FailsafeCircuitBreakerBuilder circuitBreakerBuilder = this.circuitBreakerManager.newCircuitBreaker(name);
        FailsafeCircuitBreakerDefinition circuitBreakerDefinition = this.microprofileAnnotationMapper.mapCircuitBreaker(method, circuitBreaker, circuitBreakerBuilder);
        return new FailsafeCircuitBreaker(circuitBreakerDefinition);
    }

    private org.apache.safeguard.api.bulkhead.Bulkhead createBulkhead(String name, Method method) {
        Bulkhead annotation = AnnotationUtil.getAnnotation(method, Bulkhead.class);
        if (annotation == null) {
            return null;
        }
        boolean async = AnnotationUtil.getAnnotation(method, Asynchronous.class) != null;
        BulkheadBuilder bulkheadBuilder = this.bulkheadManager.newBulkheadBuilder(name).withMaxWaiting(annotation.waitingTaskQueue()).withMaxConcurrency(annotation.value());
        if (async) {
            bulkheadBuilder.asynchronous();
        }
        bulkheadBuilder.build();
        return this.bulkheadManager.getBulkhead(name);
    }

    private FallbackRunner createFallback(Method method) {
        Fallback fallback = AnnotationUtil.getAnnotation(method, Fallback.class);
        if (fallback == null) {
            return null;
        }
        String methodName = "".equals(fallback.fallbackMethod()) ? null : fallback.fallbackMethod();
        return new FallbackRunner(fallback.value(), methodName);
    }

    private boolean isAsync(Method method) {
        return AnnotationUtil.getAnnotation(method, Asynchronous.class) != null && AnnotationUtil.getAnnotation(method, Bulkhead.class) == null;
    }

    private Duration readTimeout(Method method) {
        Timeout timeout = AnnotationUtil.getAnnotation(method, Timeout.class);
        if (timeout == null) {
            return null;
        }
        return Duration.of(timeout.value(), timeout.unit());
    }
}

