/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.executionPlans;

import java.util.concurrent.Callable;
import javax.interceptor.InvocationContext;
import org.apache.safeguard.api.bulkhead.Bulkhead;
import org.apache.safeguard.exception.SafeguardException;
import org.apache.safeguard.impl.executionPlans.ExecutionPlan;

public class BulkheadExecutionPlan
implements ExecutionPlan {
    private final Bulkhead bulkhead;
    private ExecutionPlan child;

    BulkheadExecutionPlan(Bulkhead bulkhead) {
        this.bulkhead = bulkhead;
    }

    void setChild(ExecutionPlan child) {
        this.child = child;
    }

    @Override
    public <T> T execute(Callable<T> callable, InvocationContext invocationContext) {
        if (this.bulkhead != null && this.child != null) {
            return (T)this.child.execute(() -> this.bulkhead.execute(callable), invocationContext);
        }
        if (this.child != null) {
            return this.child.execute(callable, invocationContext);
        }
        throw new SafeguardException("Neither bulkhead nor child specified");
    }
}

