/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.executionPlans;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.interceptor.InvocationContext;
import org.apache.safeguard.impl.executionPlans.ExecutionPlan;

class AsyncTimeoutExecutionPlan
implements ExecutionPlan {
    private final Duration timeout;
    private final ExecutorService executorService;

    AsyncTimeoutExecutionPlan(Duration timeout, ExecutorService executorService) {
        this.timeout = timeout;
        this.executorService = executorService;
    }

    @Override
    public <T> T execute(Callable<T> callable, InvocationContext invocationContext) {
        Future<T> future = this.executorService.submit(callable);
        try {
            return future.get(this.timeout.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() != null && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException((Throwable)e);
        }
    }
}

