/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.executionPlans;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.interceptor.InvocationContext;
import org.apache.safeguard.exception.AsyncException;
import org.apache.safeguard.impl.executionPlans.ExecutionPlan;

class AsyncOnlyExecutionPlan
implements ExecutionPlan {
    private final ExecutorService executorService;

    AsyncOnlyExecutionPlan(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public <T> T execute(Callable<T> callable, InvocationContext invocationContext) {
        Future<T> submitted = this.executorService.submit(callable);
        try {
            return submitted.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AsyncException(e);
        }
    }
}

