/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.executionPlans;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import javax.interceptor.InvocationContext;
import net.jodah.failsafe.AsyncFailsafe;
import org.apache.safeguard.impl.circuitbreaker.FailsafeCircuitBreaker;
import org.apache.safeguard.impl.executionPlans.SyncFailsafeExecutionPlan;
import org.apache.safeguard.impl.executionPlans.TimeoutWrappedCallable;
import org.apache.safeguard.impl.fallback.FallbackRunner;
import org.apache.safeguard.impl.retry.FailsafeRetryDefinition;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;

public class AsyncFailsafeExecutionPlan
extends SyncFailsafeExecutionPlan {
    private final ScheduledExecutorService executorService;
    private final Duration timeout;

    public AsyncFailsafeExecutionPlan(FailsafeRetryDefinition retryDefinition, FailsafeCircuitBreaker failsafeCircuitBreaker, FallbackRunner fallback, ScheduledExecutorService executorService, Duration timeout) {
        super(retryDefinition, failsafeCircuitBreaker, fallback);
        this.executorService = executorService;
        this.timeout = timeout;
    }

    @Override
    public <T> T execute(Callable<T> callable, InvocationContext invocationContext) {
        AsyncFailsafe asyncFailsafe = this.getSyncFailsafe(invocationContext).with(this.executorService);
        try {
            if (this.timeout == null) {
                return (T)asyncFailsafe.get(callable).get();
            }
            return (T)asyncFailsafe.get(new TimeoutWrappedCallable<T>(callable, this.executorService, this.timeout, this.failsafeCircuitBreaker)).get();
        }
        catch (net.jodah.failsafe.CircuitBreakerOpenException e) {
            throw new CircuitBreakerOpenException((Throwable)e);
        }
        catch (InterruptedException | ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new RuntimeException(e);
            }
            if (cause instanceof net.jodah.failsafe.CircuitBreakerOpenException) {
                throw new CircuitBreakerOpenException(cause);
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e);
        }
    }
}

