/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.config;

import java.lang.reflect.Method;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeoutException;
import javax.enterprise.inject.Vetoed;
import org.apache.safeguard.api.config.ConfigFacade;
import org.apache.safeguard.impl.circuitbreaker.FailsafeCircuitBreakerBuilder;
import org.apache.safeguard.impl.circuitbreaker.FailsafeCircuitBreakerDefinition;
import org.apache.safeguard.impl.retry.FailsafeRetryBuilder;
import org.apache.safeguard.impl.retry.FailsafeRetryDefinition;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Retry;

@Vetoed
public class MicroprofileAnnotationMapper {
    private static MicroprofileAnnotationMapper INSTANCE = new MicroprofileAnnotationMapper();
    private final ConfigFacade configFacade;
    private static final String RETRY_CLASS_FORMAT = "%s/Retry/%s";
    private static final String RETRY_METHOD_FORMAT = "%s/%s/Retry/%s";
    private static final String CIRCUIT_BREAKER_CLASS_FORMAT = "%s/CircuitBreaker/%s";
    private static final String CIRCUIT_BREAKER_METHOD_FORMAT = "%s/%s/CircuitBreaker/%s";

    private MicroprofileAnnotationMapper() {
        this(ConfigFacade.getInstance());
    }

    public MicroprofileAnnotationMapper(ConfigFacade configFacade) {
        this.configFacade = configFacade;
    }

    public FailsafeRetryDefinition mapRetry(Method method, Retry retry, FailsafeRetryBuilder retryBuilder) {
        boolean methodLevel = method.isAnnotationPresent(Retry.class);
        int maxRetries = this.getRetryValue(method, "maxRetries", methodLevel, retry.maxRetries());
        Class[] retryOn = this.getRetryValue(method, "retryOn", methodLevel, retry.retryOn());
        Class[] abortOn = this.getRetryValue(method, "abortOn", methodLevel, retry.abortOn());
        long delay = this.getRetryValue(method, "delay", methodLevel, retry.delay());
        ChronoUnit delayUnit = this.getRetryValue(method, "delayUnit", methodLevel, retry.delayUnit());
        long jitter = this.getRetryValue(method, "jitter", methodLevel, retry.jitter());
        ChronoUnit jitterUnit = this.getRetryValue(method, "jitterDelayUnit", methodLevel, retry.jitterDelayUnit());
        long maxDuration = this.getRetryValue(method, "maxDuration", methodLevel, retry.maxDuration());
        ChronoUnit maxDurationUnit = this.getRetryValue(method, "durationUnit", methodLevel, retry.durationUnit());
        retryBuilder.withMaxRetries(maxRetries).withRetryOn(retryOn).withRetryOn(new Class[]{TimeoutException.class, org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException.class}).withAbortOn(abortOn);
        if (delay > 0L) {
            retryBuilder.withDelay(Duration.of(delay, delayUnit));
        }
        if (jitter > 0L) {
            retryBuilder.withJitter(Duration.of(jitter, jitterUnit));
        }
        if (maxDuration > 0L) {
            retryBuilder.withMaxDuration(Duration.of(maxDuration, maxDurationUnit));
        }
        return retryBuilder.build();
    }

    public FailsafeCircuitBreakerDefinition mapCircuitBreaker(Method method, CircuitBreaker circuitBreaker, FailsafeCircuitBreakerBuilder builder) {
        boolean methodLevel = method.isAnnotationPresent(CircuitBreaker.class);
        double failureRatio = this.getCBValue(method, "failureRatio", methodLevel, circuitBreaker.failureRatio());
        int requestVolumeThreshold = this.getCBValue(method, "requestVolumeThreshold", methodLevel, circuitBreaker.requestVolumeThreshold());
        Class[] failOn = this.getCBValue(method, "failOn", methodLevel, circuitBreaker.failOn());
        long delay = this.getCBValue(method, "delay", methodLevel, circuitBreaker.delay());
        ChronoUnit delayUnit = this.getCBValue(method, "delayUnit", methodLevel, circuitBreaker.delayUnit());
        int successThreshold = this.getCBValue(method, "successThreshold", methodLevel, circuitBreaker.successThreshold());
        int failureCount = (int)(failureRatio * (double)requestVolumeThreshold);
        FailsafeCircuitBreakerBuilder failsafeCircuitBreakerBuilder = builder.withFailOn(failOn).withFailOn(new Class[]{TimeoutException.class, org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException.class}).withDelay(Duration.of(delay, delayUnit)).withSuccessCount(successThreshold);
        if (failureCount > 0) {
            failsafeCircuitBreakerBuilder.withFailures(failureCount, requestVolumeThreshold);
        }
        return failsafeCircuitBreakerBuilder.build();
    }

    public static MicroprofileAnnotationMapper getInstance() {
        return INSTANCE;
    }

    public static void setInstance(MicroprofileAnnotationMapper microprofileAnnotationMapper) {
        INSTANCE = microprofileAnnotationMapper;
    }

    private int getRetryValue(Method method, String name, boolean isMethod, int defaultValue) {
        String methodKey = String.format(RETRY_METHOD_FORMAT, method.getDeclaringClass().getName(), method.getName(), name);
        int value = this.configFacade.getInt(methodKey, defaultValue);
        if (value != defaultValue || isMethod) {
            return value;
        }
        String classKey = String.format(RETRY_CLASS_FORMAT, method.getDeclaringClass().getName(), name);
        return this.configFacade.getInt(classKey, defaultValue);
    }

    private long getRetryValue(Method method, String name, boolean isMethod, long defaultValue) {
        String methodKey = String.format(RETRY_METHOD_FORMAT, method.getDeclaringClass().getName(), method.getName(), name);
        long value = this.configFacade.getLong(methodKey, defaultValue);
        if (value != defaultValue || isMethod) {
            return value;
        }
        String classKey = String.format(RETRY_CLASS_FORMAT, method.getDeclaringClass().getName(), name);
        return this.configFacade.getLong(classKey, defaultValue);
    }

    private ChronoUnit getRetryValue(Method method, String name, boolean isMethod, ChronoUnit defaultValue) {
        String methodKey = String.format(RETRY_METHOD_FORMAT, method.getDeclaringClass().getName(), method.getName(), name);
        ChronoUnit value = this.configFacade.getChronoUnit(methodKey, defaultValue);
        if (value != defaultValue || isMethod) {
            return value;
        }
        String classKey = String.format(RETRY_CLASS_FORMAT, method.getDeclaringClass().getName(), name);
        return this.configFacade.getChronoUnit(classKey, defaultValue);
    }

    private Class[] getRetryValue(Method method, String name, boolean isMethod, Class[] defaultValue) {
        String methodKey = String.format(RETRY_METHOD_FORMAT, method.getDeclaringClass().getName(), method.getName(), name);
        Class[] value = this.configFacade.getThrowableClasses(methodKey, defaultValue);
        if (value != defaultValue || isMethod) {
            return value;
        }
        String classKey = String.format(RETRY_CLASS_FORMAT, method.getDeclaringClass().getName(), name);
        return this.configFacade.getThrowableClasses(classKey, defaultValue);
    }

    private int getCBValue(Method method, String name, boolean isMethod, int defaultValue) {
        String methodKey = String.format(CIRCUIT_BREAKER_METHOD_FORMAT, method.getDeclaringClass().getName(), method.getName(), name);
        int value = this.configFacade.getInt(methodKey, defaultValue);
        if (value != defaultValue || isMethod) {
            return value;
        }
        String classKey = String.format(CIRCUIT_BREAKER_CLASS_FORMAT, method.getDeclaringClass().getName(), name);
        return this.configFacade.getInt(classKey, defaultValue);
    }

    private long getCBValue(Method method, String name, boolean isMethod, long defaultValue) {
        String methodKey = String.format(CIRCUIT_BREAKER_METHOD_FORMAT, method.getDeclaringClass().getName(), method.getName(), name);
        long value = this.configFacade.getLong(methodKey, defaultValue);
        if (value != defaultValue || isMethod) {
            return value;
        }
        String classKey = String.format(CIRCUIT_BREAKER_CLASS_FORMAT, method.getDeclaringClass().getName(), name);
        return this.configFacade.getLong(classKey, defaultValue);
    }

    private double getCBValue(Method method, String name, boolean isMethod, double defaultValue) {
        String methodKey = String.format(CIRCUIT_BREAKER_METHOD_FORMAT, method.getDeclaringClass().getName(), method.getName(), name);
        double value = this.configFacade.getDouble(methodKey, defaultValue);
        if (value != defaultValue || isMethod) {
            return value;
        }
        String classKey = String.format(CIRCUIT_BREAKER_CLASS_FORMAT, method.getDeclaringClass().getName(), name);
        return this.configFacade.getDouble(classKey, defaultValue);
    }

    private ChronoUnit getCBValue(Method method, String name, boolean isMethod, ChronoUnit defaultValue) {
        String methodKey = String.format(CIRCUIT_BREAKER_METHOD_FORMAT, method.getDeclaringClass().getName(), method.getName(), name);
        ChronoUnit value = this.configFacade.getChronoUnit(methodKey, defaultValue);
        if (value != defaultValue || isMethod) {
            return value;
        }
        String classKey = String.format(CIRCUIT_BREAKER_CLASS_FORMAT, method.getDeclaringClass().getName(), name);
        return this.configFacade.getChronoUnit(classKey, defaultValue);
    }

    private Class[] getCBValue(Method method, String name, boolean isMethod, Class[] defaultValue) {
        String methodKey = String.format(CIRCUIT_BREAKER_METHOD_FORMAT, method.getDeclaringClass().getName(), method.getName(), name);
        Class[] value = this.configFacade.getThrowableClasses(methodKey, defaultValue);
        if (value != defaultValue || isMethod) {
            return value;
        }
        String classKey = String.format(CIRCUIT_BREAKER_CLASS_FORMAT, method.getDeclaringClass().getName(), name);
        return this.configFacade.getThrowableClasses(classKey, defaultValue);
    }
}

