/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.config;

import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.safeguard.api.config.ConfigFacade;

class DefaultConfigFacade
extends ConfigFacade {
    DefaultConfigFacade() {
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return this.getOptionalValue(name).map(Boolean::parseBoolean).orElse(defaultValue);
    }

    public long getLong(String name, long defaultValue) {
        return this.getOptionalValue(name).map(Long::parseLong).orElse(defaultValue);
    }

    public int getInt(String name, int defaultValue) {
        return this.getOptionalValue(name).map(Integer::parseInt).orElse(defaultValue);
    }

    public double getDouble(String name, double defaultValue) {
        return this.getOptionalValue(name).map(Double::parseDouble).orElse(defaultValue);
    }

    public ChronoUnit getChronoUnit(String name, ChronoUnit defaultValue) {
        return this.getOptionalValue(name).map(ChronoUnit::valueOf).orElse(defaultValue);
    }

    public Class<? extends Throwable>[] getThrowableClasses(String name, Class<? extends Throwable>[] defaultValue) {
        return this.getOptionalValue(name).map(value -> {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return (Class[])Stream.of(name.split(",")).map(clazz -> {
                try {
                    return loader.loadClass(clazz.trim());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            }).toArray(Class[]::new);
        }).orElse(defaultValue);
    }

    private Optional<String> getOptionalValue(String name) {
        return Optional.ofNullable(Optional.ofNullable(System.getenv(name)).orElseGet(() -> System.getProperty(name)));
    }
}

