/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.config;

import java.time.temporal.ChronoUnit;
import javax.annotation.Priority;
import org.apache.safeguard.api.config.ConfigFacade;
import org.apache.safeguard.impl.config.DefaultConfigFacade;
import org.apache.safeguard.impl.config.MicroProfileConfigFacade;

@Priority(value=1)
public class ConfigFacadeFacade
extends ConfigFacade {
    private final ConfigFacade delegate = this.loadDelegate();

    private ConfigFacade loadDelegate() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> loadClass = loader.loadClass("org.eclipse.microprofile.config.ConfigProvider");
            loadClass.getMethod("getConfig", new Class[0]).invoke(null, new Object[0]);
            return new MicroProfileConfigFacade();
        }
        catch (Throwable notHere) {
            return new DefaultConfigFacade();
        }
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return this.delegate.getBoolean(name, defaultValue);
    }

    public long getLong(String name, long defaultValue) {
        return this.delegate.getLong(name, defaultValue);
    }

    public int getInt(String name, int defaultValue) {
        return this.delegate.getInt(name, defaultValue);
    }

    public double getDouble(String name, double defaultValue) {
        return this.delegate.getDouble(name, defaultValue);
    }

    public ChronoUnit getChronoUnit(String name, ChronoUnit defaultValue) {
        return this.delegate.getChronoUnit(name, defaultValue);
    }

    public Class<? extends Throwable>[] getThrowableClasses(String name, Class<? extends Throwable>[] defaultValue) {
        return this.delegate.getThrowableClasses(name, (Class[])defaultValue);
    }
}

