/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.circuitbreaker;

import java.time.Duration;
import java.util.Collection;
import net.jodah.failsafe.CircuitBreaker;
import org.apache.safeguard.api.circuitbreaker.CircuitBreakerDefinition;

public class FailsafeCircuitBreakerDefinition
implements CircuitBreakerDefinition {
    private final CircuitBreaker circuitBreaker;
    private final Collection<Class<? extends Throwable>> failOnExceptions;

    public FailsafeCircuitBreakerDefinition(CircuitBreaker circuitBreaker, Collection<Class<? extends Throwable>> failOnExceptions) {
        this.circuitBreaker = circuitBreaker;
        this.failOnExceptions = failOnExceptions;
    }

    public Collection<Class<? extends Throwable>> getFailOn() {
        return this.failOnExceptions;
    }

    public Duration getDelay() {
        net.jodah.failsafe.util.Duration delay = this.circuitBreaker.getDelay();
        return Duration.ofMillis(delay.toMillis());
    }

    public int getRequestVolumeThreshold() {
        return this.circuitBreaker.getFailureThreshold().denominator;
    }

    public double getFailureRatio() {
        return this.circuitBreaker.getFailureThreshold().ratio;
    }

    public int getSuccessThreshold() {
        return this.circuitBreaker.getSuccessThreshold().denominator;
    }

    public double getSuccessRatio() {
        return this.circuitBreaker.getSuccessThreshold().ratio;
    }

    public CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }
}

