/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.circuitbreaker;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.CircuitBreaker;
import org.apache.safeguard.api.circuitbreaker.CircuitBreakerBuilder;
import org.apache.safeguard.impl.circuitbreaker.FailsafeCircuitBreakerDefinition;
import org.apache.safeguard.impl.circuitbreaker.FailsafeCircuitBreakerManager;

public class FailsafeCircuitBreakerBuilder
implements CircuitBreakerBuilder {
    private final String name;
    private final FailsafeCircuitBreakerManager failsafeCircuitBreakerManager;
    private final CircuitBreaker circuitBreaker;
    private final Collection<Class<? extends Throwable>> failOns;

    public FailsafeCircuitBreakerBuilder(String name, FailsafeCircuitBreakerManager failsafeCircuitBreakerManager) {
        this.name = name;
        this.failsafeCircuitBreakerManager = failsafeCircuitBreakerManager;
        this.circuitBreaker = new CircuitBreaker();
        this.failOns = new ArrayList<Class<? extends Throwable>>();
    }

    public FailsafeCircuitBreakerBuilder withDelay(Duration delay) {
        this.circuitBreaker.withDelay(delay.toNanos(), TimeUnit.NANOSECONDS);
        return this;
    }

    public FailsafeCircuitBreakerBuilder withFailureCount(int failureCount) {
        this.circuitBreaker.withFailureThreshold(failureCount);
        return this;
    }

    public FailsafeCircuitBreakerBuilder withFailures(int failureCount, int requestCount) {
        this.circuitBreaker.withFailureThreshold(failureCount, requestCount);
        return this;
    }

    public FailsafeCircuitBreakerBuilder withSuccessCount(int successCount) {
        this.circuitBreaker.withSuccessThreshold(successCount);
        return this;
    }

    public FailsafeCircuitBreakerBuilder withSuccesses(int successCount, int requestCount) {
        this.circuitBreaker.withSuccessThreshold(successCount, requestCount);
        return this;
    }

    public FailsafeCircuitBreakerBuilder withFailOn(Class<? extends Throwable> ... failOn) {
        this.failOns.addAll(Arrays.asList(failOn));
        this.circuitBreaker.failOn((Class[])failOn);
        return this;
    }

    public FailsafeCircuitBreakerDefinition build() {
        if (this.failOns.isEmpty()) {
            throw new IllegalStateException("At least one exception must be registered for failure detection");
        }
        FailsafeCircuitBreakerDefinition failsafeCircuitBreakerDefinition = new FailsafeCircuitBreakerDefinition(this.circuitBreaker, this.failOns);
        this.failsafeCircuitBreakerManager.register(this.name, failsafeCircuitBreakerDefinition);
        return failsafeCircuitBreakerDefinition;
    }
}

