/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.circuitbreaker;

import net.jodah.failsafe.CircuitBreaker;
import org.apache.safeguard.api.circuitbreaker.CircuitBreaker;
import org.apache.safeguard.api.circuitbreaker.CircuitBreakerState;
import org.apache.safeguard.impl.circuitbreaker.FailsafeCircuitBreakerDefinition;

public class FailsafeCircuitBreaker
implements CircuitBreaker {
    private final FailsafeCircuitBreakerDefinition circuitBreakerDefinition;

    public FailsafeCircuitBreaker(FailsafeCircuitBreakerDefinition circuitBreakerDefinition) {
        this.circuitBreakerDefinition = circuitBreakerDefinition;
    }

    public FailsafeCircuitBreakerDefinition getDefinition() {
        return this.circuitBreakerDefinition;
    }

    public CircuitBreakerState getState() {
        CircuitBreaker.State state = this.circuitBreakerDefinition.getCircuitBreaker().getState();
        switch (state) {
            case OPEN: {
                return CircuitBreakerState.OPEN;
            }
            case CLOSED: {
                return CircuitBreakerState.CLOSED;
            }
            case HALF_OPEN: {
                return CircuitBreakerState.HALF_OPEN;
            }
        }
        throw new RuntimeException("Unknown state " + state);
    }

    public void transitionState(CircuitBreakerState state) {
        switch (state) {
            case OPEN: {
                this.circuitBreakerDefinition.getCircuitBreaker().open();
                break;
            }
            case CLOSED: {
                this.circuitBreakerDefinition.getCircuitBreaker().close();
                break;
            }
            case HALF_OPEN: {
                this.circuitBreakerDefinition.getCircuitBreaker().halfOpen();
            }
        }
    }
}

