/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.cdi;

import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.safeguard.api.SafeguardEnabled;
import org.apache.safeguard.impl.FailsafeExecutionManager;
import org.apache.safeguard.impl.util.AnnotationUtil;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

@Interceptor
@SafeguardEnabled
@Priority(value=400)
@Dependent
public class SafeguardInterceptor {
    @Inject
    private FailsafeExecutionManager failsafeExecutionManager;

    @AroundInvoke
    public Object runSafeguards(InvocationContext invocationContext) throws Exception {
        if (this.isMethodSafeguarded(invocationContext.getMethod())) {
            return this.failsafeExecutionManager.execute(invocationContext);
        }
        return invocationContext.proceed();
    }

    private boolean isMethodSafeguarded(Method method) {
        return AnnotationUtil.getAnnotation(method, Retry.class) != null || AnnotationUtil.getAnnotation(method, CircuitBreaker.class) != null || AnnotationUtil.getAnnotation(method, Timeout.class) != null || AnnotationUtil.getAnnotation(method, Fallback.class) != null || AnnotationUtil.getAnnotation(method, Bulkhead.class) != null;
    }
}

