/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import org.apache.safeguard.api.SafeguardEnabled;
import org.apache.safeguard.impl.cdi.MicroProfileValidator;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

public class SafeguardExtension
implements Extension {
    private MicroProfileValidator microProfileValidator = new MicroProfileValidator();

    public <X> void findFaultTolerantBeans(@Observes @WithAnnotations(value={Retry.class, CircuitBreaker.class, Timeout.class, Bulkhead.class}) ProcessAnnotatedType<X> pat) {
        if (!pat.getAnnotatedType().isAnnotationPresent(SafeguardEnabled.class)) {
            pat.setAnnotatedType(new SafeguardAnnotatedTypeWrapper(pat.getAnnotatedType()));
        }
        this.microProfileValidator.parse(pat.getAnnotatedType());
    }

    public void throwExceptions(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        this.microProfileValidator.forThrowable(arg_0 -> ((AfterBeanDiscovery)afterBeanDiscovery).addDefinitionError(arg_0));
    }

    private static class SafeguardAnnotatedTypeWrapper<X>
    implements AnnotatedType<X> {
        private final AnnotatedType<X> delegate;
        private final Set<Annotation> annotations;

        private SafeguardAnnotatedTypeWrapper(AnnotatedType<X> delegate) {
            this.delegate = delegate;
            Set annotations = delegate.getAnnotations();
            LinkedHashSet<Annotation> allAnotations = new LinkedHashSet<Annotation>();
            allAnotations.add((Annotation)SafeguardEnabled.INSTANCE);
            allAnotations.addAll(annotations);
            this.annotations = allAnotations;
        }

        public Class<X> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        public Set<AnnotatedConstructor<X>> getConstructors() {
            return this.delegate.getConstructors();
        }

        public Set<AnnotatedMethod<? super X>> getMethods() {
            return this.delegate.getMethods();
        }

        public Set<AnnotatedField<? super X>> getFields() {
            return this.delegate.getFields();
        }

        public Type getBaseType() {
            return this.delegate.getBaseType();
        }

        public Set<Type> getTypeClosure() {
            return this.delegate.getTypeClosure();
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            return (T)(SafeguardEnabled.class.equals(annotationType) ? SafeguardEnabled.INSTANCE : this.delegate.getAnnotation(annotationType));
        }

        public Set<Annotation> getAnnotations() {
            return Collections.unmodifiableSet(this.annotations);
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return SafeguardEnabled.class.equals(annotationType) || this.delegate.isAnnotationPresent(annotationType);
        }
    }
}

