/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.cdi;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.safeguard.exception.SafeguardException;
import org.apache.safeguard.impl.util.AnnotationUtil;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

@Vetoed
final class MicroProfileValidator {
    private List<Throwable> capturedThrowables = new ArrayList<Throwable>();

    MicroProfileValidator() {
    }

    void parse(AnnotatedType<?> annotatedType) {
        for (AnnotatedMethod method : annotatedType.getMethods()) {
            Fallback fallback;
            CircuitBreaker circuitBreaker;
            Timeout timeout;
            Bulkhead bulkhead;
            Retry retry = AnnotationUtil.getAnnotation(method, annotatedType, Retry.class);
            if (retry != null) {
                this.validateRetry(retry, method);
            }
            if ((bulkhead = AnnotationUtil.getAnnotation(method, annotatedType, Bulkhead.class)) != null) {
                this.validateBulkhead(bulkhead, method);
            }
            if ((timeout = AnnotationUtil.getAnnotation(method, annotatedType, Timeout.class)) != null) {
                this.validateTimeout(timeout, method);
            }
            if ((circuitBreaker = AnnotationUtil.getAnnotation(method, annotatedType, CircuitBreaker.class)) != null) {
                this.validateCircuitBreaker(circuitBreaker, method);
            }
            if ((fallback = AnnotationUtil.getAnnotation(method, annotatedType, Fallback.class)) == null) continue;
            this.validateFallback(fallback, method, annotatedType);
        }
    }

    private void validateFallback(Fallback fallback, AnnotatedMethod<?> method, AnnotatedType<?> annotatedType) {
        if (fallback.fallbackMethod().equals("") && fallback.value().equals(Fallback.DEFAULT.class)) {
            this.capturedThrowables.add((Throwable)new SafeguardException("Invalid Fallback definition on method " + method));
        } else if (!fallback.fallbackMethod().equals("") && !fallback.value().equals(Fallback.DEFAULT.class)) {
            this.capturedThrowables.add((Throwable)new SafeguardException("Invalid Fallback definition on method " + method));
        } else if (!fallback.fallbackMethod().equals("")) {
            boolean found = false;
            for (AnnotatedMethod otherMethod : annotatedType.getMethods()) {
                if (!otherMethod.getJavaMember().getName().equals(fallback.fallbackMethod())) continue;
                found = true;
                if (!method.getJavaMember().getReturnType().equals(otherMethod.getJavaMember().getReturnType())) {
                    this.capturedThrowables.add((Throwable)new SafeguardException("Invalid Fallback definition on method " + method + " wrong return type"));
                    continue;
                }
                if (Arrays.equals(method.getJavaMember().getParameterTypes(), otherMethod.getJavaMember().getParameterTypes())) continue;
                this.capturedThrowables.add((Throwable)new SafeguardException("Invalid Fallback definition on method " + method + " wrong parameters"));
            }
            if (!found) {
                this.capturedThrowables.add((Throwable)new SafeguardException("Invalid Fallback definition on method " + method + " fallback method not found"));
            }
        } else {
            try {
                Method methodHandle = fallback.value().getMethod("handle", ExecutionContext.class);
                if (!methodHandle.getReturnType().equals(method.getJavaMember().getReturnType())) {
                    this.capturedThrowables.add((Throwable)new SafeguardException("Invalid Fallback definition on method " + method + " wrong return type"));
                }
            }
            catch (NoSuchMethodException e) {
                this.capturedThrowables.add((Throwable)new SafeguardException("Invalid Fallback definition on method " + method + " fallback method not found"));
            }
        }
    }

    private void validateTimeout(Timeout timeout, AnnotatedMethod<?> method) {
        if (timeout.value() < 0L) {
            this.capturedThrowables.add((Throwable)new SafeguardException("Invalid Timeout definition on method " + method));
        }
    }

    private void validateCircuitBreaker(CircuitBreaker circuitBreaker, AnnotatedMethod<?> method) {
        if (circuitBreaker.requestVolumeThreshold() <= 0 || circuitBreaker.delay() < 0L || circuitBreaker.failureRatio() < 0.0 || circuitBreaker.failureRatio() > 1.0 || circuitBreaker.successThreshold() <= 0) {
            this.capturedThrowables.add((Throwable)new SafeguardException("Invalid CircuitBreaker definition on method " + method));
        }
    }

    private void validateRetry(Retry retry, AnnotatedMethod<?> method) {
        if (retry.jitter() < 0L || retry.maxDuration() < 0L || retry.delay() < 0L || retry.maxRetries() < 0) {
            this.capturedThrowables.add((Throwable)new SafeguardException("Invalid Retry definition on method " + method));
        }
        Duration delay = Duration.of(retry.delay(), retry.delayUnit());
        Duration maxDuration = Duration.of(retry.maxDuration(), retry.durationUnit());
        if (maxDuration.compareTo(delay) < 0) {
            this.capturedThrowables.add((Throwable)new SafeguardException("Invalid Retry definition on method " + method));
        }
    }

    private void validateBulkhead(Bulkhead bulkhead, AnnotatedMethod<?> method) {
        if (bulkhead.value() < 0 || bulkhead.waitingTaskQueue() < 0) {
            this.capturedThrowables.add((Throwable)new SafeguardException("Invalid Bulkhead definition on method " + method));
        }
    }

    void forThrowable(Consumer<Throwable> consumer) {
        this.capturedThrowables.forEach(consumer);
    }
}

