/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.bulkhead;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.safeguard.api.bulkhead.Bulkhead;
import org.apache.safeguard.api.bulkhead.BulkheadDefinition;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;

public class ThreadPoolBulkhead
implements Bulkhead {
    private final BulkheadDefinition bulkheadDefinition;
    private final BlockingQueue<Runnable> workQueue;
    private final ThreadPoolExecutor threadPoolExecutor;

    public ThreadPoolBulkhead(BulkheadDefinition bulkheadDefinition) {
        this.bulkheadDefinition = bulkheadDefinition;
        this.workQueue = new LinkedBlockingQueue<Runnable>(bulkheadDefinition.getMaxWaitingExecutions());
        this.threadPoolExecutor = new ThreadPoolExecutor(bulkheadDefinition.getMaxConcurrentExecutions(), bulkheadDefinition.getMaxConcurrentExecutions(), 0L, TimeUnit.MILLISECONDS, this.workQueue, Executors.defaultThreadFactory());
    }

    public BulkheadDefinition getBulkheadDefinition() {
        return this.bulkheadDefinition;
    }

    public int getCurrentQueueDepth() {
        return this.workQueue.size();
    }

    public int getCurrentExecutions() {
        return this.threadPoolExecutor.getActiveCount();
    }

    public <T> T execute(Callable<T> callable) {
        try {
            return (T)new DelegatingFuture(this.threadPoolExecutor.submit(callable));
        }
        catch (RejectedExecutionException e) {
            throw new BulkheadException((Throwable)e);
        }
    }

    private class DelegatingFuture<R>
    implements Future<R> {
        private final Future<Future<R>> child;

        public DelegatingFuture(Future<Future<R>> child) {
            this.child = child;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.child.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.child.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.child.isDone();
        }

        @Override
        public R get() throws InterruptedException, ExecutionException {
            return this.child.get().get();
        }

        @Override
        public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.child.get().get(timeout, unit);
        }
    }
}

