/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.bulkhead;

import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import org.apache.safeguard.api.bulkhead.Bulkhead;
import org.apache.safeguard.api.bulkhead.BulkheadDefinition;
import org.apache.safeguard.exception.SafeguardException;

public class SemaphoreBulkhead
implements Bulkhead {
    private final Semaphore semaphore;
    private final BulkheadDefinition bulkheadDefinition;

    public SemaphoreBulkhead(BulkheadDefinition bulkheadDefinition) {
        this.semaphore = new Semaphore(bulkheadDefinition.getMaxConcurrentExecutions(), true);
        this.bulkheadDefinition = bulkheadDefinition;
    }

    public BulkheadDefinition getBulkheadDefinition() {
        return this.bulkheadDefinition;
    }

    public int getCurrentQueueDepth() {
        return this.semaphore.getQueueLength();
    }

    public int getCurrentExecutions() {
        return this.bulkheadDefinition.getMaxConcurrentExecutions() - this.semaphore.availablePermits();
    }

    public <T> T execute(Callable<T> callable) {
        try {
            String name = Thread.currentThread().getName();
            this.semaphore.acquire();
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new SafeguardException((Throwable)e);
        }
        finally {
            this.semaphore.release();
        }
    }
}

